/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.PigWarning;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.FileList;
import org.apache.pig.data.SortedSpillBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class InternalDistinctBag
extends SortedSpillBag {
    private static final long serialVersionUID = 2L;
    private static final Log log = LogFactory.getLog(InternalDistinctBag.class);
    private static TupleFactory gTupleFactory = TupleFactory.getInstance();
    private transient boolean mReadStarted = false;

    public InternalDistinctBag() {
        this(1, -1.0f);
    }

    public InternalDistinctBag(int bagCount) {
        this(bagCount, -1.0f);
    }

    public InternalDistinctBag(int bagCount, float percent) {
        super(bagCount, percent);
        if (percent < 0.0f) {
            String usage;
            percent = 0.2f;
            if (PigMapReduce.sJobConfInternal.get() != null && (usage = ((Configuration)PigMapReduce.sJobConfInternal.get()).get("pig.cachedbag.memusage")) != null) {
                percent = Float.parseFloat(usage);
            }
        }
        this.init(bagCount, percent);
    }

    private void init(int bagCount, double percent) {
        this.mContents = new HashSet();
    }

    @Override
    public boolean isSorted() {
        return false;
    }

    @Override
    public boolean isDistinct() {
        return true;
    }

    @Override
    public long size() {
        if (this.mSpillFiles != null && this.mSpillFiles.size() > 0) {
            Iterator<Tuple> iter = this.iterator();
            int newSize = 0;
            while (iter.hasNext()) {
                ++newSize;
                iter.next();
            }
            this.mSize = newSize;
        }
        return this.mSize;
    }

    @Override
    public Iterator<Tuple> iterator() {
        return new DistinctDataBagIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Tuple t) {
        Collection collection = this.mContents;
        synchronized (collection) {
            if (this.mReadStarted) {
                throw new IllegalStateException("InternalDistinctBag is closed for adding new tuples");
            }
            if ((long)this.mContents.size() > this.memLimit.getCacheLimit()) {
                this.proactive_spill(null);
            }
            if (this.mContents.add(t)) {
                ++this.mSize;
                if (this.mSize < 100L && (this.mSpillFiles == null || this.mSpillFiles.isEmpty())) {
                    this.memLimit.addNewObjSize(t.getMemorySize());
                }
            }
            this.markSpillableIfNecessary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long spill() {
        Collection collection = this.mContents;
        synchronized (collection) {
            if (this.mReadStarted) {
                return 0L;
            }
            return this.proactive_spill(null);
        }
    }

    private class DistinctDataBagIterator
    implements Iterator<Tuple> {
        private Tuple mBuf = null;
        private int mMemoryPtr = 0;
        private TreeSet<TContainer> mMergeTree = null;
        private ArrayList<DataInputStream> mStreams = null;
        private int mCntr = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DistinctDataBagIterator() {
            Collection collection = InternalDistinctBag.this.mContents;
            synchronized (collection) {
                if (!InternalDistinctBag.this.mReadStarted) {
                    this.preMerge();
                    ArrayList l = new ArrayList(InternalDistinctBag.this.mContents);
                    Collections.sort(l);
                    InternalDistinctBag.this.mContents = l;
                    InternalDistinctBag.this.mReadStarted = true;
                }
            }
        }

        @Override
        public boolean hasNext() {
            this.mBuf = this.next();
            return this.mBuf != null;
        }

        @Override
        public Tuple next() {
            if ((this.mCntr++ & 0x3FF) == 0) {
                InternalDistinctBag.this.reportProgress();
            }
            if (this.mBuf != null) {
                Tuple t = this.mBuf;
                this.mBuf = null;
                return t;
            }
            if (InternalDistinctBag.this.mSpillFiles == null || InternalDistinctBag.this.mSpillFiles.size() == 0) {
                return this.readFromMemory();
            }
            return this.readFromTree();
        }

        @Override
        public void remove() {
        }

        private Tuple readFromTree() {
            if (this.mMergeTree == null) {
                this.mMergeTree = new TreeSet();
                this.mStreams = new ArrayList(InternalDistinctBag.this.mSpillFiles.size() + 1);
                Iterator i = InternalDistinctBag.this.mSpillFiles.iterator();
                while (i.hasNext()) {
                    try {
                        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream((File)i.next())));
                        this.mStreams.add(in);
                        this.addToQueue(null, this.mStreams.size() - 1);
                    }
                    catch (FileNotFoundException fnfe) {
                        String msg = "Unable to find our spill file.";
                        log.fatal((Object)msg, (Throwable)fnfe);
                        throw new RuntimeException(msg, fnfe);
                    }
                }
                if (InternalDistinctBag.this.mContents.size() > 0) {
                    this.addToQueue(null, -1);
                }
            }
            if (this.mMergeTree.size() == 0) {
                return null;
            }
            TContainer c = this.mMergeTree.first();
            this.mMergeTree.remove(c);
            Tuple t = c.tuple;
            this.addToQueue(c, c.fileNum);
            return t;
        }

        private void addToQueue(TContainer c, int fileNum) {
            if (c == null) {
                c = new TContainer();
            }
            c.fileNum = fileNum;
            if (fileNum == -1) {
                do {
                    c.tuple = this.readFromMemory();
                    if (c.tuple == null || !this.mMergeTree.add(c)) continue;
                    return;
                } while (c.tuple != null);
                return;
            }
            DataInputStream in = this.mStreams.get(fileNum);
            if (in != null) {
                c.tuple = gTupleFactory.newTuple();
                try {
                    do {
                        c.tuple.readFields(in);
                    } while (!this.mMergeTree.add(c));
                    return;
                }
                catch (EOFException eof) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)"Failed to close spill file.", (Throwable)e);
                    }
                    this.mStreams.set(fileNum, null);
                    return;
                }
                catch (IOException ioe) {
                    String msg = "Unable to find our spill file.";
                    log.fatal((Object)msg, (Throwable)ioe);
                    throw new RuntimeException(msg, ioe);
                }
            }
        }

        private Tuple readFromMemory() {
            if (InternalDistinctBag.this.mContents.size() == 0) {
                return null;
            }
            if (this.mMemoryPtr < InternalDistinctBag.this.mContents.size()) {
                return (Tuple)((ArrayList)InternalDistinctBag.this.mContents).get(this.mMemoryPtr++);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void preMerge() {
            if (InternalDistinctBag.this.mSpillFiles == null || InternalDistinctBag.this.mSpillFiles.size() <= 100) {
                return;
            }
            try {
                LinkedList<File> ll = new LinkedList<File>(InternalDistinctBag.this.mSpillFiles);
                LinkedList<File> filesToDelete = new LinkedList<File>();
                while (ll.size() > 100) {
                    String msg;
                    ListIterator i = ll.listIterator();
                    this.mStreams = new ArrayList(100);
                    this.mMergeTree = new TreeSet();
                    for (int j = 0; j < 100; ++j) {
                        try {
                            File f = (File)i.next();
                            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(f)));
                            this.mStreams.add(in);
                            this.addToQueue(null, this.mStreams.size() - 1);
                            i.remove();
                            filesToDelete.add(f);
                            continue;
                        }
                        catch (FileNotFoundException fnfe) {
                            msg = "Unable to find our spill file.";
                            log.fatal((Object)msg, (Throwable)fnfe);
                            throw new RuntimeException(msg, fnfe);
                        }
                    }
                    DataOutputStream out = null;
                    try {
                        Tuple t;
                        out = InternalDistinctBag.this.getSpillFile();
                        ll.add((File)InternalDistinctBag.this.mSpillFiles.get(InternalDistinctBag.this.mSpillFiles.size() - 1));
                        while ((t = this.readFromTree()) != null) {
                            t.write(out);
                        }
                        out.flush();
                    }
                    catch (IOException ioe) {
                        msg = "Unable to find our spill file.";
                        log.fatal((Object)msg, (Throwable)ioe);
                        throw new RuntimeException(msg, ioe);
                    }
                    finally {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            InternalDistinctBag.this.warn("Error closing spill", PigWarning.UNABLE_TO_CLOSE_SPILL_FILE, e);
                        }
                    }
                }
                for (File f : filesToDelete) {
                    if (f.delete()) continue;
                    log.warn((Object)("Failed to delete spill file: " + f.getPath()));
                }
                InternalDistinctBag.this.mSpillFiles.clear();
                InternalDistinctBag.this.mSpillFiles = new FileList(ll);
            }
            finally {
                this.mStreams = null;
                this.mMergeTree = null;
            }
        }

        private class TContainer
        implements Comparable<TContainer> {
            public Tuple tuple;
            public int fileNum;

            private TContainer() {
            }

            @Override
            public int compareTo(TContainer other) {
                return this.tuple.compareTo(other.tuple);
            }

            public boolean equals(Object obj) {
                if (obj instanceof TContainer) {
                    return this.compareTo((TContainer)obj) == 0;
                }
                return false;
            }

            public int hashCode() {
                return this.tuple.hashCode();
            }
        }
    }
}

