/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.Iterator;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.pen.util.ExampleTuple;
import org.apache.pig.pen.util.LineageTracer;

public class POCross
extends PhysicalOperator {
    private static final long serialVersionUID = 1L;
    protected transient DataBag[] inputBags;
    protected transient Tuple[] data;
    protected transient Iterator<Tuple>[] its;
    protected transient Tuple tupleOfLastBag;

    public POCross(OperatorKey k) {
        super(k);
    }

    public POCross(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        super(k, rp, inp);
    }

    public POCross(OperatorKey k, int rp) {
        super(k, rp);
    }

    public POCross(OperatorKey k, List<PhysicalOperator> inp) {
        super(k, inp);
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitCross(this);
    }

    @Override
    public String name() {
        return this.getAliasString() + "POCross" + "[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return true;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        if (this.illustrator != null) {
            ExampleTuple tOut = new ExampleTuple((Tuple)out);
            this.illustrator.addData(tOut);
            this.illustrator.getEquivalenceClasses().get(eqClassIndex).add((Tuple)out);
            LineageTracer lineageTracer = this.illustrator.getLineage();
            lineageTracer.insert(tOut);
            for (int i = 0; i < this.data.length; ++i) {
                lineageTracer.union(tOut, this.data[i]);
            }
            return tOut;
        }
        return (Tuple)out;
    }

    @Override
    public Result getNextTuple() throws ExecException {
        Result res = new Result();
        int noItems = this.inputs.size();
        if (this.inputBags == null) {
            this.accumulateData();
            if (!this.loadLastBag()) {
                res.returnStatus = (byte)3;
                this.clearMemory();
                return res;
            }
        }
        if (this.its != null) {
            boolean finished = true;
            boolean empty = false;
            for (int i = 0; i < this.its.length; ++i) {
                if (this.inputBags[i].size() == 0L) {
                    empty = true;
                    break;
                }
                finished &= !this.its[i].hasNext();
            }
            if (empty) {
                int index = this.inputs.size() - 1;
                Result resOfLastBag = ((PhysicalOperator)this.inputs.get(index)).getNextTuple();
                while (resOfLastBag.returnStatus != 3) {
                    resOfLastBag = ((PhysicalOperator)this.inputs.get(index)).getNextTuple();
                }
                res.returnStatus = (byte)3;
                this.clearMemory();
                return res;
            }
            if (finished && !this.loadLastBag()) {
                res.returnStatus = (byte)3;
                this.clearMemory();
                return res;
            }
        }
        if (this.data == null) {
            this.data = new Tuple[noItems];
            this.data[noItems - 1] = this.tupleOfLastBag;
            for (int i = 0; i < noItems - 1; ++i) {
                this.data[i] = this.its[i].next();
            }
            res.result = this.createTuple(this.data);
            res.returnStatus = 0;
            return res;
        }
        this.data[noItems - 1] = this.tupleOfLastBag;
        int length = noItems - 1;
        for (int index = 0; index < length; ++index) {
            if (this.its[index].hasNext()) {
                this.data[index] = this.its[index].next();
                res.result = this.createTuple(this.data);
                res.returnStatus = 0;
                return res;
            }
            this.its[index] = this.inputBags[index].iterator();
            this.data[index] = this.its[index].next();
        }
        res.result = this.createTuple(this.data);
        res.returnStatus = 0;
        return res;
    }

    private void accumulateData() throws ExecException {
        int count = 0;
        int length = this.inputs.size() - 1;
        this.inputBags = new DataBag[length];
        this.its = new Iterator[length];
        for (int i = 0; i < length; ++i) {
            DataBag bag;
            PhysicalOperator op = (PhysicalOperator)this.inputs.get(i);
            this.inputBags[count] = bag = mBagFactory.newDefaultBag();
            Result res = op.getNextTuple();
            while (res.returnStatus != 3) {
                if (res.returnStatus != 1) {
                    if (res.returnStatus == 2) {
                        throw new ExecException("Error accumulating data in the local Cross operator");
                    }
                    if (res.returnStatus == 0) {
                        bag.add((Tuple)res.result);
                    }
                }
                res = op.getNextTuple();
            }
            this.its[count++] = bag.iterator();
        }
    }

    private Tuple createTuple(Tuple[] data) throws ExecException {
        Tuple out = TupleFactory.getInstance().newTuple();
        for (int i = 0; i < data.length; ++i) {
            Tuple t = data[i];
            int size = t.size();
            for (int j = 0; j < size; ++j) {
                out.append(t.get(j));
            }
        }
        return this.illustratorMarkup(out, out, 0);
    }

    private boolean loadLastBag() throws ExecException {
        Result resOfLastBag = null;
        int index = this.inputs.size() - 1;
        resOfLastBag = ((PhysicalOperator)this.inputs.get(index)).getNextTuple();
        while (resOfLastBag.returnStatus == 1) {
            ((PhysicalOperator)this.inputs.get(index)).getNextTuple();
        }
        switch (resOfLastBag.returnStatus) {
            case 3: {
                return false;
            }
            case 0: {
                this.tupleOfLastBag = (Tuple)resOfLastBag.result;
                return true;
            }
        }
        throw new ExecException("Error accumulating data in the local Cross operator");
    }

    private void clearMemory() {
        this.tupleOfLastBag = null;
        this.inputBags = null;
        this.its = null;
        this.data = null;
    }
}

