/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.partitioners;

import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.lib.partition.HashPartitioner;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.HDataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.PigNullableWritable;

public class SecondaryKeyPartitioner
extends HashPartitioner<PigNullableWritable, Writable>
implements Configurable {
    Byte kt;

    public int getPartition(PigNullableWritable key, Writable value, int numPartitions) {
        try {
            Tuple t = (Tuple)key.getValueAsPigType();
            PigNullableWritable realKey = HDataType.getWritableComparableTypes(t.get(0), this.kt);
            return super.getPartition((Object)realKey, (Object)value, numPartitions);
        }
        catch (ExecException e) {
            throw new RuntimeException(e);
        }
    }

    public Configuration getConf() {
        throw new UnsupportedOperationException();
    }

    public void setConf(Configuration conf) {
        String kts = conf.get("pig.reduce.key.type");
        this.kt = Byte.valueOf(kts);
    }
}

