/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector.primitive;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;

public class WritableConstantHiveDecimalObjectInspector
extends WritableHiveDecimalObjectInspector
implements ConstantObjectInspector {
    private HiveDecimalWritable value;

    protected WritableConstantHiveDecimalObjectInspector() {
    }

    WritableConstantHiveDecimalObjectInspector(DecimalTypeInfo typeInfo, HiveDecimalWritable value) {
        super(typeInfo);
        this.value = value;
    }

    @Override
    public HiveDecimalWritable getWritableConstantValue() {
        HiveDecimal dec;
        DecimalTypeInfo decTypeInfo = (DecimalTypeInfo)this.typeInfo;
        HiveDecimal hiveDecimal = dec = this.value == null ? null : this.value.getHiveDecimal(decTypeInfo.precision(), decTypeInfo.scale());
        if (dec == null) {
            return null;
        }
        return new HiveDecimalWritable(dec);
    }

    @Override
    public int precision() {
        if (this.value == null) {
            return super.precision();
        }
        return this.value.getHiveDecimal().precision();
    }

    @Override
    public int scale() {
        if (this.value == null) {
            return super.scale();
        }
        return this.value.getHiveDecimal().scale();
    }
}

