/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.DataReaderWriter;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class FileSplitComparable
implements WritableComparable<FileSplitComparable>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String filename;
    protected Long offset;

    public FileSplitComparable() {
    }

    public FileSplitComparable(String fileName, long offset) {
        this.filename = fileName;
        this.offset = offset;
    }

    public int compareTo(FileSplitComparable other) {
        int rc = this.filename.compareTo(other.filename);
        if (rc == 0) {
            rc = Long.signum(this.offset - other.offset);
        }
        return rc;
    }

    public void readFields(DataInput in) throws IOException {
        this.filename = (String)DataReaderWriter.readDatum(in);
        this.offset = (Long)DataReaderWriter.readDatum(in);
    }

    public void write(DataOutput out) throws IOException {
        DataReaderWriter.writeDatum(out, this.filename);
        DataReaderWriter.writeDatum(out, this.offset);
    }

    public String toString() {
        return "FileName: '" + this.filename + "' Offset: " + this.offset;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
        result = 31 * result + (this.offset == null ? 0 : this.offset.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileSplitComparable other = (FileSplitComparable)obj;
        if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
            return false;
        }
        return !(this.offset == null ? other.offset != null : !this.offset.equals(other.offset));
    }
}

