/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSink;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Strings;

@InterfaceAudience.Private
public class ReplicationLoad {
    public static final ReplicationLoad EMPTY_REPLICATIONLOAD = new ReplicationLoad();
    private List<MetricsSource> sourceMetricsList;
    private MetricsSink sinkMetrics;
    private List<ClusterStatusProtos.ReplicationLoadSource> replicationLoadSourceList;
    private ClusterStatusProtos.ReplicationLoadSink replicationLoadSink;

    public void buildReplicationLoad(List<MetricsSource> srMetricsList, MetricsSink skMetrics) {
        this.sourceMetricsList = srMetricsList;
        this.sinkMetrics = skMetrics;
        ClusterStatusProtos.ReplicationLoadSink.Builder rLoadSinkBuild = ClusterStatusProtos.ReplicationLoadSink.newBuilder();
        rLoadSinkBuild.setAgeOfLastAppliedOp(this.sinkMetrics.getAgeOfLastAppliedOp());
        rLoadSinkBuild.setTimeStampsOfLastAppliedOp(this.sinkMetrics.getTimeStampOfLastAppliedOp());
        this.replicationLoadSink = rLoadSinkBuild.build();
        this.replicationLoadSourceList = new ArrayList<ClusterStatusProtos.ReplicationLoadSource>();
        for (MetricsSource sm : this.sourceMetricsList) {
            long ageOfLastShippedOp = sm.getAgeOfLastShippedOp();
            int sizeOfLogQueue = sm.getSizeOfLogQueue();
            long timeStampOfLastShippedOp = sm.getTimeStampOfLastShippedOp();
            long timePassedAfterLastShippedOp = EnvironmentEdgeManager.currentTimeMillis() - timeStampOfLastShippedOp;
            long replicationLag = sizeOfLogQueue != 0 ? Math.max(ageOfLastShippedOp, timePassedAfterLastShippedOp) : (timePassedAfterLastShippedOp < 2L * ageOfLastShippedOp ? ageOfLastShippedOp : 0L);
            ClusterStatusProtos.ReplicationLoadSource.Builder rLoadSourceBuild = ClusterStatusProtos.ReplicationLoadSource.newBuilder();
            rLoadSourceBuild.setPeerID(sm.getPeerID());
            rLoadSourceBuild.setAgeOfLastShippedOp(ageOfLastShippedOp);
            rLoadSourceBuild.setSizeOfLogQueue(sizeOfLogQueue);
            rLoadSourceBuild.setTimeStampOfLastShippedOp(timeStampOfLastShippedOp);
            rLoadSourceBuild.setReplicationLag(replicationLag);
            this.replicationLoadSourceList.add(rLoadSourceBuild.build());
        }
    }

    public String sourceToString() {
        if (this.sourceMetricsList == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (ClusterStatusProtos.ReplicationLoadSource rls : this.replicationLoadSourceList) {
            sb = Strings.appendKeyValue((StringBuilder)sb, (String)"\n           PeerID", (Object)rls.getPeerID());
            sb = Strings.appendKeyValue((StringBuilder)sb, (String)"AgeOfLastShippedOp", (Object)rls.getAgeOfLastShippedOp());
            sb = Strings.appendKeyValue((StringBuilder)sb, (String)"SizeOfLogQueue", (Object)rls.getSizeOfLogQueue());
            sb = Strings.appendKeyValue((StringBuilder)sb, (String)"TimeStampsOfLastShippedOp", (Object)new Date(rls.getTimeStampOfLastShippedOp()).toString());
            sb = Strings.appendKeyValue((StringBuilder)sb, (String)"Replication Lag", (Object)rls.getReplicationLag());
        }
        return sb.toString();
    }

    public String sinkToString() {
        if (this.replicationLoadSink == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"AgeOfLastAppliedOp", (Object)this.replicationLoadSink.getAgeOfLastAppliedOp());
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"TimeStampsOfLastAppliedOp", (Object)new Date(this.replicationLoadSink.getTimeStampsOfLastAppliedOp()).toString());
        return sb.toString();
    }

    public ClusterStatusProtos.ReplicationLoadSink getReplicationLoadSink() {
        return this.replicationLoadSink;
    }

    public List<ClusterStatusProtos.ReplicationLoadSource> getReplicationLoadSourceList() {
        return this.replicationLoadSourceList;
    }

    public String toString() {
        return this.sourceToString() + System.getProperty("line.separator") + this.sinkToString();
    }
}

