/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.io.IOException;
import java.util.Arrays;
import java.util.TreeSet;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.util.TableDiskUsage;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

public class DUCommand
extends Shell.Command {
    private Option optTablePattern;
    private Option optHumanReadble;

    @Override
    public int execute(String fullCommand, CommandLine cl, final Shell shellState) throws IOException, TableNotFoundException {
        boolean prettyPrint;
        TreeSet<String> tablesToFlush = new TreeSet<String>(Arrays.asList(cl.getArgs()));
        boolean bl = prettyPrint = cl.hasOption(this.optHumanReadble.getOpt());
        if (cl.hasOption(this.optTablePattern.getOpt())) {
            for (String table : shellState.getConnector().tableOperations().list()) {
                if (!table.matches(cl.getOptionValue(this.optTablePattern.getOpt()))) continue;
                tablesToFlush.add(table);
            }
        } else {
            shellState.checkTableState();
            tablesToFlush.add(shellState.getTableName());
        }
        try {
            ConfigurationCopy acuConf = new ConfigurationCopy(shellState.getConnector().instanceOperations().getSystemConfiguration());
            TableDiskUsage.printDiskUsage(acuConf, tablesToFlush, FileSystem.get((Configuration)new Configuration()), shellState.getConnector(), new TableDiskUsage.Printer(){

                @Override
                public void print(String line) {
                    try {
                        shellState.getReader().printString(line + "\n");
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }, prettyPrint);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return 0;
    }

    @Override
    public String description() {
        return "prints how much space, in bytes, is used by files referenced by a table.  When multiple tables are specified it prints how much space, in bytes, is used by files shared between tables, if any.";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.optTablePattern = new Option("p", "pattern", true, "regex pattern of table names");
        this.optTablePattern.setArgName("pattern");
        this.optHumanReadble = new Option("h", "human-readable", false, "format large sizes to human readable units");
        this.optHumanReadble.setArgName("human readable output");
        o.addOption(this.optTablePattern);
        o.addOption(this.optHumanReadble);
        return o;
    }

    @Override
    public String usage() {
        return this.getName() + " <table>{ <table>}";
    }

    @Override
    public int numArgs() {
        return -1;
    }
}

