/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.impl.ClientExec;
import org.apache.accumulo.core.client.impl.ClientExecReturn;
import org.apache.accumulo.core.client.impl.ThriftTransportPool;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.util.AddressUtil;
import org.apache.accumulo.core.util.TTimeoutTransport;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.trace.instrument.Span;
import org.apache.accumulo.trace.instrument.Trace;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.TServiceClientFactory;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;

public class ThriftUtil {
    private static final Logger log = Logger.getLogger(ThriftUtil.class);
    private static TProtocolFactory protocolFactory = new TraceProtocolFactory();
    private static TTransportFactory transportFactory = new TFramedTransport.Factory(Integer.MAX_VALUE);
    private static final Map<Integer, TTransportFactory> factoryCache = new HashMap<Integer, TTransportFactory>();

    public static <T extends TServiceClient> T createClient(TServiceClientFactory<T> factory, TTransport transport) {
        return (T)factory.getClient(protocolFactory.getProtocol(transport), protocolFactory.getProtocol(transport));
    }

    public static <T extends TServiceClient> T getClient(TServiceClientFactory<T> factory, InetSocketAddress address, AccumuloConfiguration conf) throws TTransportException {
        return ThriftUtil.createClient(factory, ThriftTransportPool.getInstance().getTransportWithDefaultTimeout(address, conf));
    }

    public static <T extends TServiceClient> T getClient(TServiceClientFactory<T> factory, String address, Property property, AccumuloConfiguration configuration) throws TTransportException {
        int port = configuration.getPort(property);
        TTransport transport = ThriftTransportPool.getInstance().getTransport(address, port);
        return ThriftUtil.createClient(factory, transport);
    }

    public static <T extends TServiceClient> T getClient(TServiceClientFactory<T> factory, String address, Property property, Property timeoutProperty, AccumuloConfiguration configuration) throws TTransportException {
        return ThriftUtil.getClient(factory, address, property, configuration.getTimeInMillis(timeoutProperty), configuration);
    }

    public static <T extends TServiceClient> T getClient(TServiceClientFactory<T> factory, String address, Property property, long timeout, AccumuloConfiguration configuration) throws TTransportException {
        int port = configuration.getPort(property);
        TTransport transport = ThriftTransportPool.getInstance().getTransport(address, port, timeout);
        return ThriftUtil.createClient(factory, transport);
    }

    public static void returnClient(TServiceClient iface) {
        if (iface != null) {
            ThriftTransportPool.getInstance().returnTransport(iface.getInputProtocol().getTransport());
        }
    }

    public static TabletClientService.Client getTServerClient(String address, AccumuloConfiguration conf) throws TTransportException {
        return ThriftUtil.getClient(new TabletClientService.Client.Factory(), address, Property.TSERV_CLIENTPORT, Property.GENERAL_RPC_TIMEOUT, conf);
    }

    public static TabletClientService.Client getTServerClient(String address, AccumuloConfiguration conf, long timeout) throws TTransportException {
        return ThriftUtil.getClient(new TabletClientService.Client.Factory(), address, Property.TSERV_CLIENTPORT, timeout, conf);
    }

    public static void execute(String address, AccumuloConfiguration conf, ClientExec<TabletClientService.Client> exec) throws AccumuloException, AccumuloSecurityException {
        while (true) {
            TabletClientService.Client client = null;
            try {
                client = ThriftUtil.getTServerClient(address, conf);
                exec.execute(client);
            }
            catch (TTransportException tte) {
                log.debug((Object)"getTServerClient request failed, retrying ... ", (Throwable)tte);
                UtilWaitThread.sleep(100L);
                continue;
            }
            catch (ThriftSecurityException e) {
                throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
            }
            catch (Exception e) {
                throw new AccumuloException(e);
            }
            finally {
                if (client == null) continue;
                ThriftUtil.returnClient(client);
                continue;
            }
            break;
        }
    }

    public static <T> T execute(String address, AccumuloConfiguration conf, ClientExecReturn<T, TabletClientService.Client> exec) throws AccumuloException, AccumuloSecurityException {
        while (true) {
            TabletClientService.Client client = null;
            try {
                client = ThriftUtil.getTServerClient(address, conf);
                T t = exec.execute(client);
                return t;
            }
            catch (TTransportException tte) {
                log.debug((Object)"getTServerClient request failed, retrying ... ", (Throwable)tte);
                UtilWaitThread.sleep(100L);
                continue;
            }
            catch (ThriftSecurityException e) {
                throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
            }
            catch (Exception e) {
                throw new AccumuloException(e);
            }
            finally {
                if (client == null) continue;
                ThriftUtil.returnClient(client);
                continue;
            }
            break;
        }
    }

    public static TTransport createTransport(String address, int port, AccumuloConfiguration conf) throws TException {
        TTransport transport = null;
        try {
            transport = TTimeoutTransport.create(AddressUtil.parseAddress(address, port), conf.getTimeInMillis(Property.GENERAL_RPC_TIMEOUT));
            transport = ThriftUtil.transportFactory().getTransport(transport);
            transport.open();
            TTransport tmp = transport;
            transport = null;
            TTransport tTransport = tmp;
            return tTransport;
        }
        catch (IOException ex) {
            throw new TTransportException((Throwable)ex);
        }
        finally {
            if (transport != null) {
                transport.close();
            }
        }
    }

    public static TTransport createTransport(InetSocketAddress address, AccumuloConfiguration conf) throws TException {
        return ThriftUtil.createTransport(address.getAddress().getHostAddress(), address.getPort(), conf);
    }

    public static TTransportFactory transportFactory() {
        return transportFactory;
    }

    public static synchronized TTransportFactory transportFactory(int maxFrameSize) {
        TTransportFactory factory = factoryCache.get(maxFrameSize);
        if (factory == null) {
            factory = new TFramedTransport.Factory(maxFrameSize);
            factoryCache.put(maxFrameSize, factory);
        }
        return factory;
    }

    public static synchronized TTransportFactory transportFactory(long maxFrameSize) {
        if (maxFrameSize > Integer.MAX_VALUE || maxFrameSize < 1L) {
            throw new RuntimeException("Thrift transport frames are limited to 2147483647");
        }
        return ThriftUtil.transportFactory((int)maxFrameSize);
    }

    public static TProtocolFactory protocolFactory() {
        return protocolFactory;
    }

    public static class TraceProtocolFactory
    extends TCompactProtocol.Factory {
        private static final long serialVersionUID = 1L;

        public TProtocol getProtocol(TTransport trans) {
            return new TraceProtocol(trans);
        }
    }

    public static class TraceProtocol
    extends TCompactProtocol {
        public void writeMessageBegin(TMessage message) throws TException {
            Trace.start((String)("client:" + message.name));
            super.writeMessageBegin(message);
        }

        public void writeMessageEnd() throws TException {
            super.writeMessageEnd();
            Span currentTrace = Trace.currentTrace();
            if (currentTrace != null) {
                currentTrace.stop();
            }
        }

        public TraceProtocol(TTransport transport) {
            super(transport);
        }
    }
}

