/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.spi.SelectorProvider;
import org.apache.hadoop.net.NetUtils;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TTimeoutTransport {
    private static InputStream getInputStream(Socket socket, long timeout) {
        try {
            Method m = NetUtils.class.getMethod("getInputStream", Socket.class, Long.TYPE);
            return (InputStream)m.invoke(null, socket, timeout);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static TTransport create(SocketAddress addr, long timeoutMillis) throws IOException {
        Socket socket = SelectorProvider.provider().openSocketChannel().socket();
        socket.setSoLinger(false, 0);
        socket.setTcpNoDelay(true);
        socket.connect(addr);
        BufferedInputStream input = new BufferedInputStream(TTimeoutTransport.getInputStream(socket, timeoutMillis), 10240);
        BufferedOutputStream output = new BufferedOutputStream(NetUtils.getOutputStream((Socket)socket, (long)timeoutMillis), 10240);
        return new TIOStreamTransport((InputStream)input, (OutputStream)output);
    }
}

