/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.security.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.security.crypto.CryptoModule;
import org.apache.accumulo.core.security.crypto.SecretKeyEncryptionStrategy;
import org.apache.accumulo.core.security.crypto.SecretKeyEncryptionStrategyContext;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.log4j.Logger;

@Deprecated
public class CryptoModuleFactory {
    private static Logger log = Logger.getLogger(CryptoModuleFactory.class);

    public static CryptoModule getCryptoModule(AccumuloConfiguration conf) {
        String cryptoModuleClassname = conf.get(Property.CRYPTO_MODULE_CLASS);
        return CryptoModuleFactory.getCryptoModule(cryptoModuleClassname);
    }

    public static CryptoModule getCryptoModule(String cryptoModuleClassname) {
        log.debug((Object)String.format("About to instantiate crypto module %s", cryptoModuleClassname));
        if (cryptoModuleClassname.equals("NullCryptoModule")) {
            return new NullCryptoModule();
        }
        CryptoModule cryptoModule = null;
        Class cryptoModuleClazz = null;
        try {
            cryptoModuleClazz = AccumuloVFSClassLoader.loadClass((String)cryptoModuleClassname);
        }
        catch (ClassNotFoundException e1) {
            log.warn((Object)String.format("Could not find configured crypto module \"%s\".  NO ENCRYPTION WILL BE USED.", cryptoModuleClassname));
            return new NullCryptoModule();
        }
        Class<?>[] interfaces = cryptoModuleClazz.getInterfaces();
        boolean implementsCryptoModule = false;
        for (Class<?> clazz : interfaces) {
            if (!clazz.equals(CryptoModule.class)) continue;
            implementsCryptoModule = true;
            break;
        }
        if (!implementsCryptoModule) {
            log.warn((Object)"Configured Accumulo crypto module \"%s\" does not implement the CryptoModule interface. NO ENCRYPTION WILL BE USED.");
            return new NullCryptoModule();
        }
        try {
            cryptoModule = (CryptoModule)cryptoModuleClazz.newInstance();
            log.debug((Object)"Successfully instantiated crypto module");
        }
        catch (InstantiationException e) {
            log.warn((Object)String.format("Got instantiation exception %s when instantiating crypto module \"%s\".  NO ENCRYPTION WILL BE USED.", e.getCause().getClass().getCanonicalName(), cryptoModuleClassname));
            log.warn((Object)e.getCause());
            return new NullCryptoModule();
        }
        catch (IllegalAccessException e) {
            log.warn((Object)String.format("Got illegal access exception when trying to instantiate crypto module \"%s\".  NO ENCRYPTION WILL BE USED.", cryptoModuleClassname));
            log.warn((Object)e);
            return new NullCryptoModule();
        }
        return cryptoModule;
    }

    public static SecretKeyEncryptionStrategy getSecretKeyEncryptionStrategy(AccumuloConfiguration conf) {
        String className = conf.get(Property.CRYPTO_SECRET_KEY_ENCRYPTION_STRATEGY_CLASS);
        return CryptoModuleFactory.getSecretKeyEncryptionStrategy(className);
    }

    public static SecretKeyEncryptionStrategy getSecretKeyEncryptionStrategy(String className) {
        if (className == null || className.equals("NullSecretKeyEncryptionStrategy")) {
            return new NullSecretKeyEncryptionStrategy();
        }
        SecretKeyEncryptionStrategy strategy = null;
        Class keyEncryptionStrategyClazz = null;
        try {
            keyEncryptionStrategyClazz = AccumuloVFSClassLoader.loadClass((String)className);
        }
        catch (ClassNotFoundException e1) {
            log.warn((Object)String.format("Could not find configured secret key encryption strategy \"%s\".  NO ENCRYPTION WILL BE USED.", className));
            return new NullSecretKeyEncryptionStrategy();
        }
        Class<?>[] interfaces = keyEncryptionStrategyClazz.getInterfaces();
        boolean implementsSecretKeyStrategy = false;
        for (Class<?> clazz : interfaces) {
            if (!clazz.equals(SecretKeyEncryptionStrategy.class)) continue;
            implementsSecretKeyStrategy = true;
            break;
        }
        if (!implementsSecretKeyStrategy) {
            log.warn((Object)"Configured Accumulo secret key encryption strategy \"%s\" does not implement the SecretKeyEncryptionStrategy interface. NO ENCRYPTION WILL BE USED.");
            return new NullSecretKeyEncryptionStrategy();
        }
        try {
            strategy = (SecretKeyEncryptionStrategy)keyEncryptionStrategyClazz.newInstance();
            log.debug((Object)"Successfully instantiated secret key encryption strategy");
        }
        catch (InstantiationException e) {
            log.warn((Object)String.format("Got instantiation exception %s when instantiating secret key encryption strategy \"%s\".  NO ENCRYPTION WILL BE USED.", e.getCause().getClass().getCanonicalName(), className));
            log.warn((Object)e.getCause());
            return new NullSecretKeyEncryptionStrategy();
        }
        catch (IllegalAccessException e) {
            log.warn((Object)String.format("Got illegal access exception when trying to instantiate secret key encryption strategy \"%s\".  NO ENCRYPTION WILL BE USED.", className));
            log.warn((Object)e);
            return new NullSecretKeyEncryptionStrategy();
        }
        return strategy;
    }

    private static class NullCryptoModule
    implements CryptoModule {
        private NullCryptoModule() {
        }

        @Override
        public OutputStream getEncryptingOutputStream(OutputStream out, Map<String, String> cryptoOpts) throws IOException {
            return out;
        }

        @Override
        public InputStream getDecryptingInputStream(InputStream in, Map<String, String> cryptoOpts) throws IOException {
            return in;
        }

        @Override
        public OutputStream getEncryptingOutputStream(OutputStream out, Map<String, String> conf, Map<CryptoModule.CryptoInitProperty, Object> cryptoInitParams) {
            return out;
        }

        @Override
        public InputStream getDecryptingInputStream(InputStream in, Map<String, String> cryptoOpts, Map<CryptoModule.CryptoInitProperty, Object> cryptoInitParams) throws IOException {
            return in;
        }
    }

    private static class NullSecretKeyEncryptionStrategy
    implements SecretKeyEncryptionStrategy {
        private NullSecretKeyEncryptionStrategy() {
        }

        @Override
        public SecretKeyEncryptionStrategyContext encryptSecretKey(SecretKeyEncryptionStrategyContext context) {
            context.setEncryptedSecretKey(context.getPlaintextSecretKey());
            context.setOpaqueKeyEncryptionKeyID("");
            return context;
        }

        @Override
        public SecretKeyEncryptionStrategyContext decryptSecretKey(SecretKeyEncryptionStrategyContext context) {
            context.setPlaintextSecretKey(context.getEncryptedSecretKey());
            return context;
        }

        @Override
        public SecretKeyEncryptionStrategyContext getNewContext() {
            return new SecretKeyEncryptionStrategyContext(){
                private byte[] plaintextSecretKey;
                private byte[] encryptedSecretKey;
                private String opaqueKeyEncryptionKeyID;
                private Map<String, String> context;

                @Override
                public byte[] getPlaintextSecretKey() {
                    return this.plaintextSecretKey;
                }

                @Override
                public void setPlaintextSecretKey(byte[] plaintextSecretKey) {
                    this.plaintextSecretKey = plaintextSecretKey;
                }

                @Override
                public byte[] getEncryptedSecretKey() {
                    return this.encryptedSecretKey;
                }

                @Override
                public void setEncryptedSecretKey(byte[] encryptedSecretKey) {
                    this.encryptedSecretKey = encryptedSecretKey;
                }

                @Override
                public String getOpaqueKeyEncryptionKeyID() {
                    return this.opaqueKeyEncryptionKeyID;
                }

                @Override
                public void setOpaqueKeyEncryptionKeyID(String opaqueKeyEncryptionKeyID) {
                    this.opaqueKeyEncryptionKeyID = opaqueKeyEncryptionKeyID;
                }

                @Override
                public Map<String, String> getContext() {
                    return this.context;
                }

                @Override
                public void setContext(Map<String, String> context) {
                    this.context = context;
                }
            };
        }
    }
}

