/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file;

import java.io.IOException;
import java.util.Set;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.file.BloomFilterLayer;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.file.blockfile.cache.BlockCache;
import org.apache.accumulo.core.file.map.MapFileOperations;
import org.apache.accumulo.core.file.rfile.RFileOperations;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

class DispatchingFileFactory
extends FileOperations {
    DispatchingFileFactory() {
    }

    private FileOperations findFileFactory(String file) {
        Path p = new Path(file);
        String name = p.getName();
        if (name.startsWith("map_")) {
            return new MapFileOperations();
        }
        String[] sp = name.split("\\.");
        if (sp.length != 2) {
            throw new IllegalArgumentException("File name " + name + " has no extension");
        }
        String extension = sp[1];
        if (extension.equals("map") || extension.equals("map_tmp")) {
            return new MapFileOperations();
        }
        if (extension.equals("rf") || extension.equals("rf_tmp")) {
            return new RFileOperations();
        }
        throw new IllegalArgumentException("File type " + extension + " not supported");
    }

    @Override
    public FileSKVIterator openIndex(String file, FileSystem fs, Configuration conf, AccumuloConfiguration acuconf) throws IOException {
        return this.findFileFactory(file).openIndex(file, fs, conf, acuconf, null, null);
    }

    @Override
    public FileSKVIterator openReader(String file, boolean seekToBeginning, FileSystem fs, Configuration conf, AccumuloConfiguration acuconf) throws IOException {
        FileSKVIterator iter = this.findFileFactory(file).openReader(file, seekToBeginning, fs, conf, acuconf, null, null);
        if (acuconf.getBoolean(Property.TABLE_BLOOM_ENABLED)) {
            return new BloomFilterLayer.Reader(iter, acuconf);
        }
        return iter;
    }

    @Override
    public FileSKVWriter openWriter(String file, FileSystem fs, Configuration conf, AccumuloConfiguration acuconf) throws IOException {
        FileSKVWriter writer = this.findFileFactory(file).openWriter(file, fs, conf, acuconf);
        if (acuconf.getBoolean(Property.TABLE_BLOOM_ENABLED)) {
            return new BloomFilterLayer.Writer(writer, acuconf);
        }
        return writer;
    }

    @Override
    public long getFileSize(String file, FileSystem fs, Configuration conf, AccumuloConfiguration acuconf) throws IOException {
        return this.findFileFactory(file).getFileSize(file, fs, conf, acuconf);
    }

    @Override
    public FileSKVIterator openReader(String file, Range range, Set<ByteSequence> columnFamilies, boolean inclusive, FileSystem fs, Configuration conf, AccumuloConfiguration tableConf) throws IOException {
        return this.findFileFactory(file).openReader(file, range, columnFamilies, inclusive, fs, conf, tableConf, null, null);
    }

    @Override
    public FileSKVIterator openReader(String file, Range range, Set<ByteSequence> columnFamilies, boolean inclusive, FileSystem fs, Configuration conf, AccumuloConfiguration tableConf, BlockCache dataCache, BlockCache indexCache) throws IOException {
        if (!tableConf.getBoolean(Property.TABLE_INDEXCACHE_ENABLED)) {
            indexCache = null;
        }
        if (!tableConf.getBoolean(Property.TABLE_BLOCKCACHE_ENABLED)) {
            dataCache = null;
        }
        return this.findFileFactory(file).openReader(file, range, columnFamilies, inclusive, fs, conf, tableConf, dataCache, indexCache);
    }

    @Override
    public FileSKVIterator openReader(String file, boolean seekToBeginning, FileSystem fs, Configuration conf, AccumuloConfiguration acuconf, BlockCache dataCache, BlockCache indexCache) throws IOException {
        if (!acuconf.getBoolean(Property.TABLE_INDEXCACHE_ENABLED)) {
            indexCache = null;
        }
        if (!acuconf.getBoolean(Property.TABLE_BLOCKCACHE_ENABLED)) {
            dataCache = null;
        }
        FileSKVIterator iter = this.findFileFactory(file).openReader(file, seekToBeginning, fs, conf, acuconf, dataCache, indexCache);
        if (acuconf.getBoolean(Property.TABLE_BLOOM_ENABLED)) {
            return new BloomFilterLayer.Reader(iter, acuconf);
        }
        return iter;
    }

    @Override
    public FileSKVIterator openIndex(String file, FileSystem fs, Configuration conf, AccumuloConfiguration acuconf, BlockCache dCache, BlockCache iCache) throws IOException {
        if (!acuconf.getBoolean(Property.TABLE_INDEXCACHE_ENABLED)) {
            iCache = null;
        }
        if (!acuconf.getBoolean(Property.TABLE_BLOCKCACHE_ENABLED)) {
            dCache = null;
        }
        return this.findFileFactory(file).openIndex(file, fs, conf, acuconf, dCache, iCache);
    }
}

