/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.AccumuloServerException;
import org.apache.accumulo.core.client.impl.ScannerOptions;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.client.impl.TabletLocatorImpl;
import org.apache.accumulo.core.client.impl.TabletServerBatchReaderIterator;
import org.apache.accumulo.core.client.impl.ThriftScanner;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.accumulo.core.iterators.user.WholeRowIterator;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.tabletserver.thrift.NotServingTabletException;
import org.apache.accumulo.core.util.MetadataTable;
import org.apache.accumulo.core.util.OpTimer;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class MetadataLocationObtainer
implements TabletLocatorImpl.TabletLocationObtainer {
    private static final Logger log = Logger.getLogger(MetadataLocationObtainer.class);
    private SortedSet<Column> locCols;
    private ArrayList<Column> columns;
    private Instance instance;

    MetadataLocationObtainer(Instance instance) {
        this.instance = instance;
        this.locCols = new TreeSet<Column>();
        this.locCols.add(new Column(TextUtil.getBytes(Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY), null, null));
        this.locCols.add(Constants.METADATA_PREV_ROW_COLUMN.toColumn());
        this.columns = new ArrayList<Column>(this.locCols);
    }

    @Override
    public TabletLocator.TabletLocations lookupTablet(TabletLocator.TabletLocation src, Text row, Text stopRow, TabletLocator parent, TCredentials credentials) throws AccumuloSecurityException, AccumuloException {
        try {
            ArrayList<TabletLocator.TabletLocation> list = new ArrayList<TabletLocator.TabletLocation>();
            OpTimer opTimer = null;
            if (log.isTraceEnabled()) {
                opTimer = new OpTimer(log, Level.TRACE).start("Looking up in " + src.tablet_extent.getTableId() + " row=" + TextUtil.truncate(row) + "  extent=" + src.tablet_extent + " tserver=" + src.tablet_location);
            }
            Range range = new Range(row, true, stopRow, true);
            TreeMap<Key, Value> encodedResults = new TreeMap<Key, Value>();
            TreeMap<Key, Value> results = new TreeMap<Key, Value>();
            ArrayList<IterInfo> serverSideIteratorList = new ArrayList<IterInfo>();
            serverSideIteratorList.add(new IterInfo(10000, WholeRowIterator.class.getName(), "WRI"));
            Map<String, Map<String, String>> serverSideIteratorOptions = Collections.emptyMap();
            boolean more = ThriftScanner.getBatchFromServer(credentials, range, src.tablet_extent, src.tablet_location, encodedResults, this.locCols, serverSideIteratorList, serverSideIteratorOptions, 1000, Constants.NO_AUTHS, false, this.instance.getConfiguration());
            this.decodeRows(encodedResults, results);
            if (more && results.size() == 1) {
                range = new Range(results.lastKey().followingKey(PartialKey.ROW_COLFAM_COLQUAL_COLVIS_TIME), true, new Key(stopRow).followingKey(PartialKey.ROW), false);
                encodedResults.clear();
                more = ThriftScanner.getBatchFromServer(credentials, range, src.tablet_extent, src.tablet_location, encodedResults, this.locCols, serverSideIteratorList, serverSideIteratorOptions, 1000, Constants.NO_AUTHS, false, this.instance.getConfiguration());
                this.decodeRows(encodedResults, results);
            }
            if (opTimer != null) {
                opTimer.stop("Got " + results.size() + " results  from " + src.tablet_extent + " in %DURATION%");
            }
            Pair<SortedMap<KeyExtent, Text>, List<KeyExtent>> metadata = MetadataTable.getMetadataLocationEntries(results);
            for (Map.Entry<KeyExtent, Text> entry : metadata.getFirst().entrySet()) {
                list.add(new TabletLocator.TabletLocation(entry.getKey(), entry.getValue().toString()));
            }
            return new TabletLocator.TabletLocations(list, metadata.getSecond());
        }
        catch (AccumuloServerException ase) {
            if (log.isTraceEnabled()) {
                log.trace((Object)(src.tablet_extent.getTableId() + " lookup failed, " + src.tablet_location + " server side exception"));
            }
            throw ase;
        }
        catch (NotServingTabletException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)(src.tablet_extent.getTableId() + " lookup failed, " + src.tablet_location + " not serving " + src.tablet_extent));
            }
            parent.invalidateCache(src.tablet_extent);
        }
        catch (AccumuloException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)(src.tablet_extent.getTableId() + " lookup failed"), (Throwable)e);
            }
            parent.invalidateCache(src.tablet_location);
        }
        return null;
    }

    private void decodeRows(TreeMap<Key, Value> encodedResults, TreeMap<Key, Value> results) throws AccumuloException {
        for (Map.Entry<Key, Value> entry : encodedResults.entrySet()) {
            try {
                results.putAll(WholeRowIterator.decodeRow(entry.getKey(), entry.getValue()));
            }
            catch (IOException e) {
                throw new AccumuloException(e);
            }
        }
    }

    @Override
    public List<TabletLocator.TabletLocation> lookupTablets(String tserver, Map<KeyExtent, List<Range>> tabletsRanges, TabletLocator parent, TCredentials credentials) throws AccumuloSecurityException, AccumuloException {
        final TreeMap<Key, Value> results = new TreeMap<Key, Value>();
        ArrayList<TabletLocator.TabletLocation> list = new ArrayList<TabletLocator.TabletLocation>();
        TabletServerBatchReaderIterator.ResultReceiver rr = new TabletServerBatchReaderIterator.ResultReceiver(){

            @Override
            public void receive(List<Map.Entry<Key, Value>> entries) {
                for (Map.Entry<Key, Value> entry : entries) {
                    try {
                        results.putAll(WholeRowIterator.decodeRow(entry.getKey(), entry.getValue()));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
        ScannerOptions opts = new ScannerOptions();
        opts.fetchedColumns = this.locCols;
        opts.serverSideIteratorList = new ArrayList<IterInfo>();
        opts.serverSideIteratorList.add(new IterInfo(10000, WholeRowIterator.class.getName(), "WRI"));
        HashMap<KeyExtent, List<Range>> unscanned = new HashMap<KeyExtent, List<Range>>();
        HashMap<KeyExtent, List<Range>> failures = new HashMap<KeyExtent, List<Range>>();
        try {
            TabletServerBatchReaderIterator.doLookup(tserver, tabletsRanges, failures, unscanned, rr, this.columns, credentials, opts, Constants.NO_AUTHS, this.instance.getConfiguration());
            if (failures.size() > 0) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("lookupTablets failed for " + failures.size() + " extents"));
                }
                parent.invalidateCache(failures.keySet());
            }
        }
        catch (IOException e) {
            log.trace((Object)("lookupTablets failed server=" + tserver), (Throwable)e);
            parent.invalidateCache(tserver);
        }
        catch (AccumuloServerException e) {
            log.trace((Object)("lookupTablets failed server=" + tserver), (Throwable)e);
            throw e;
        }
        SortedMap<KeyExtent, Text> metadata = MetadataTable.getMetadataLocationEntries(results).getFirst();
        for (Map.Entry<KeyExtent, Text> entry : metadata.entrySet()) {
            list.add(new TabletLocator.TabletLocation(entry.getKey(), entry.getValue().toString()));
        }
        return list;
    }
}

