/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.admin;

import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.io.Text;

public interface TableOperations {
    public SortedSet<String> list();

    public boolean exists(String var1);

    public void create(String var1) throws AccumuloException, AccumuloSecurityException, TableExistsException;

    public void create(String var1, boolean var2) throws AccumuloException, AccumuloSecurityException, TableExistsException;

    public void create(String var1, boolean var2, TimeType var3) throws AccumuloException, AccumuloSecurityException, TableExistsException;

    public void importTable(String var1, String var2) throws TableExistsException, AccumuloException, AccumuloSecurityException;

    public void exportTable(String var1, String var2) throws TableNotFoundException, AccumuloException, AccumuloSecurityException;

    public void addSplits(String var1, SortedSet<Text> var2) throws TableNotFoundException, AccumuloException, AccumuloSecurityException;

    @Deprecated
    public Collection<Text> getSplits(String var1) throws TableNotFoundException;

    public Collection<Text> listSplits(String var1) throws TableNotFoundException, AccumuloSecurityException, AccumuloException;

    @Deprecated
    public Collection<Text> getSplits(String var1, int var2) throws TableNotFoundException;

    public Collection<Text> listSplits(String var1, int var2) throws TableNotFoundException, AccumuloSecurityException, AccumuloException;

    public Text getMaxRow(String var1, Authorizations var2, Text var3, boolean var4, Text var5, boolean var6) throws TableNotFoundException, AccumuloException, AccumuloSecurityException;

    public void merge(String var1, Text var2, Text var3) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    public void deleteRows(String var1, Text var2, Text var3) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    public void compact(String var1, Text var2, Text var3, boolean var4, boolean var5) throws AccumuloSecurityException, TableNotFoundException, AccumuloException;

    public void compact(String var1, Text var2, Text var3, List<IteratorSetting> var4, boolean var5, boolean var6) throws AccumuloSecurityException, TableNotFoundException, AccumuloException;

    public void cancelCompaction(String var1) throws AccumuloSecurityException, TableNotFoundException, AccumuloException;

    public void delete(String var1) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    public void clone(String var1, String var2, boolean var3, Map<String, String> var4, Set<String> var5) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException;

    public void rename(String var1, String var2) throws AccumuloSecurityException, TableNotFoundException, AccumuloException, TableExistsException;

    @Deprecated
    public void flush(String var1) throws AccumuloException, AccumuloSecurityException;

    public void flush(String var1, Text var2, Text var3, boolean var4) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    public void setProperty(String var1, String var2, String var3) throws AccumuloException, AccumuloSecurityException;

    public void removeProperty(String var1, String var2) throws AccumuloException, AccumuloSecurityException;

    public Iterable<Map.Entry<String, String>> getProperties(String var1) throws AccumuloException, TableNotFoundException;

    public void setLocalityGroups(String var1, Map<String, Set<Text>> var2) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    public Map<String, Set<Text>> getLocalityGroups(String var1) throws AccumuloException, TableNotFoundException;

    public Set<Range> splitRangeByTablets(String var1, Range var2, int var3) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    public void importDirectory(String var1, String var2, String var3, boolean var4) throws TableNotFoundException, IOException, AccumuloException, AccumuloSecurityException;

    public void offline(String var1) throws AccumuloSecurityException, AccumuloException, TableNotFoundException;

    public void online(String var1) throws AccumuloSecurityException, AccumuloException, TableNotFoundException;

    public void clearLocatorCache(String var1) throws TableNotFoundException;

    public Map<String, String> tableIdMap();

    public void attachIterator(String var1, IteratorSetting var2) throws AccumuloSecurityException, AccumuloException, TableNotFoundException;

    public void attachIterator(String var1, IteratorSetting var2, EnumSet<IteratorUtil.IteratorScope> var3) throws AccumuloSecurityException, AccumuloException, TableNotFoundException;

    public void removeIterator(String var1, String var2, EnumSet<IteratorUtil.IteratorScope> var3) throws AccumuloSecurityException, AccumuloException, TableNotFoundException;

    public IteratorSetting getIteratorSetting(String var1, String var2, IteratorUtil.IteratorScope var3) throws AccumuloSecurityException, AccumuloException, TableNotFoundException;

    public Map<String, EnumSet<IteratorUtil.IteratorScope>> listIterators(String var1) throws AccumuloSecurityException, AccumuloException, TableNotFoundException;

    public void checkIteratorConflicts(String var1, IteratorSetting var2, EnumSet<IteratorUtil.IteratorScope> var3) throws AccumuloException, TableNotFoundException;

    public int addConstraint(String var1, String var2) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    public void removeConstraint(String var1, int var2) throws AccumuloException, AccumuloSecurityException;

    public Map<String, Integer> listConstraints(String var1) throws AccumuloException, TableNotFoundException;

    public boolean testClassLoad(String var1, String var2, String var3) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;
}

