/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.python.core.JavaIterator;
import org.python.core.Py;
import org.python.core.PyBuiltinClassMethodNarrow;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyIterator;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.Untraversable;

class JavaProxyMap {
    private static final PyBuiltinMethodNarrow mapLenProxy = new MapMethod("__len__", 0){

        @Override
        public PyObject __call__() {
            return Py.java2py(this.asMap().size());
        }
    };
    private static final PyBuiltinMethodNarrow mapReprProxy = new MapMethod("__repr__", 0){

        @Override
        public PyObject __call__() {
            StringBuilder repr2 = new StringBuilder("{");
            for (Map.Entry<Object, Object> entry : this.asMap().entrySet()) {
                Object jkey = entry.getKey();
                Object jval = entry.getValue();
                repr2.append(jkey.toString());
                repr2.append(": ");
                repr2.append(jval == this.asMap() ? "{...}" : (jval == null ? "None" : jval.toString()));
                repr2.append(", ");
            }
            int lastindex = repr2.lastIndexOf(", ");
            if (lastindex > -1) {
                repr2.delete(lastindex, lastindex + 2);
            }
            repr2.append("}");
            return new PyString(repr2.toString());
        }
    };
    private static final PyBuiltinMethodNarrow mapEqProxy = new MapMethod("__eq__", 1){

        @Override
        public PyObject __call__(PyObject other) {
            return JavaProxyMap.mapEq(this.self, other);
        }
    };
    private static final PyBuiltinMethodNarrow mapLeProxy = new MapMethod("__le__", 1){

        @Override
        public PyObject __call__(PyObject other) {
            return JavaProxyMap.mapLe(this.self, other);
        }
    };
    private static final PyBuiltinMethodNarrow mapGeProxy = new MapMethod("__ge__", 1){

        @Override
        public PyObject __call__(PyObject other) {
            return JavaProxyMap.mapLe(this.self, other).__not__().__or__(JavaProxyMap.mapEq(this.self, other));
        }
    };
    private static final PyBuiltinMethodNarrow mapLtProxy = new MapMethod("__lt__", 1){

        @Override
        public PyObject __call__(PyObject other) {
            return JavaProxyMap.mapLe(this.self, other).__and__(JavaProxyMap.mapEq(this.self, other).__not__());
        }
    };
    private static final PyBuiltinMethodNarrow mapGtProxy = new MapMethod("__gt__", 1){

        @Override
        public PyObject __call__(PyObject other) {
            return JavaProxyMap.mapLe(this.self, other).__not__();
        }
    };
    private static final PyBuiltinMethodNarrow mapIterProxy = new MapMethod("__iter__", 0){

        @Override
        public PyObject __call__() {
            return new JavaIterator(this.asMap().keySet());
        }
    };
    private static final PyBuiltinMethodNarrow mapContainsProxy = new MapMethod("__contains__", 1){

        @Override
        public PyObject __call__(PyObject obj) {
            Object other = obj.__tojava__(Object.class);
            return this.asMap().containsKey(other) ? Py.True : Py.False;
        }
    };
    private static final PyBuiltinMethodNarrow mapGetProxy = new MapMethod("get", 1, 2){

        @Override
        public PyObject __call__(PyObject key) {
            return this.__call__(key, Py.None);
        }

        @Override
        public PyObject __call__(PyObject key, PyObject _default) {
            Object jkey = Py.tojava(key, Object.class);
            if (this.asMap().containsKey(jkey)) {
                return Py.java2py(this.asMap().get(jkey));
            }
            return _default;
        }
    };
    private static final PyBuiltinMethodNarrow mapGetItemProxy = new MapMethod("__getitem__", 1){

        @Override
        public PyObject __call__(PyObject key) {
            Object jkey = Py.tojava(key, Object.class);
            if (this.asMap().containsKey(jkey)) {
                return Py.java2py(this.asMap().get(jkey));
            }
            throw Py.KeyError(key);
        }
    };
    private static final PyBuiltinMethodNarrow mapPutProxy = new MapMethod("__setitem__", 2){

        @Override
        public PyObject __call__(PyObject key, PyObject value) {
            this.asMap().put(Py.tojava(key, Object.class), value == Py.None ? Py.None : Py.tojava(value, Object.class));
            return Py.None;
        }
    };
    private static final PyBuiltinMethodNarrow mapRemoveProxy = new MapMethod("__delitem__", 1){

        @Override
        public PyObject __call__(PyObject key) {
            Object jkey = Py.tojava(key, Object.class);
            if (this.asMap().remove(jkey) == null) {
                throw Py.KeyError(key);
            }
            return Py.None;
        }
    };
    private static final PyBuiltinMethodNarrow mapIterItemsProxy = new MapMethod("iteritems", 0){

        @Override
        public PyObject __call__() {
            final Iterator<Map.Entry<Object, Object>> entrySetIterator = this.asMap().entrySet().iterator();
            return new PyIterator(){

                @Override
                public PyObject __iternext__() {
                    if (entrySetIterator.hasNext()) {
                        Map.Entry nextEntry = (Map.Entry)entrySetIterator.next();
                        return new PyTuple(Py.java2py(nextEntry.getKey()), Py.java2py(nextEntry.getValue()));
                    }
                    return null;
                }
            };
        }
    };
    private static final PyBuiltinMethodNarrow mapHasKeyProxy = new MapMethod("has_key", 1){

        @Override
        public PyObject __call__(PyObject key) {
            return this.asMap().containsKey(Py.tojava(key, Object.class)) ? Py.True : Py.False;
        }
    };
    private static final PyBuiltinMethodNarrow mapKeysProxy = new MapMethod("keys", 0){

        @Override
        public PyObject __call__() {
            PyList keys = new PyList();
            for (Object key : this.asMap().keySet()) {
                keys.add(Py.java2py(key));
            }
            return keys;
        }
    };
    private static final PyBuiltinMethod mapValuesProxy = new MapMethod("values", 0){

        @Override
        public PyObject __call__() {
            PyList values = new PyList();
            for (Object value : this.asMap().values()) {
                values.add(Py.java2py(value));
            }
            return values;
        }
    };
    private static final PyBuiltinMethodNarrow mapSetDefaultProxy = new MapMethod("setdefault", 1, 2){

        @Override
        public PyObject __call__(PyObject key) {
            return this.__call__(key, Py.None);
        }

        @Override
        public PyObject __call__(PyObject key, PyObject _default) {
            Object jkey = Py.tojava(key, Object.class);
            Object jval = this.asMap().get(jkey);
            if (jval == null) {
                this.asMap().put(jkey, _default == Py.None ? Py.None : Py.tojava(_default, Object.class));
                return _default;
            }
            return Py.java2py(jval);
        }
    };
    private static final PyBuiltinMethodNarrow mapPopProxy = new MapMethod("pop", 1, 2){

        @Override
        public PyObject __call__(PyObject key) {
            return this.__call__(key, null);
        }

        @Override
        public PyObject __call__(PyObject key, PyObject _default) {
            Object jkey = Py.tojava(key, Object.class);
            if (this.asMap().containsKey(jkey)) {
                PyObject value = Py.java2py(this.asMap().remove(jkey));
                assert (value != null);
                return Py.java2py(value);
            }
            if (_default == null) {
                throw Py.KeyError(key);
            }
            return _default;
        }
    };
    private static final PyBuiltinMethodNarrow mapPopItemProxy = new MapMethod("popitem", 0){

        @Override
        public PyObject __call__() {
            if (this.asMap().size() == 0) {
                throw Py.KeyError("popitem(): map is empty");
            }
            Object key = this.asMap().keySet().toArray()[0];
            Object val = this.asMap().remove(key);
            return Py.java2py(val);
        }
    };
    private static final PyBuiltinMethodNarrow mapItemsProxy = new MapMethod("items", 0){

        @Override
        public PyObject __call__() {
            PyList items = new PyList();
            for (Map.Entry<Object, Object> entry : this.asMap().entrySet()) {
                items.add(new PyTuple(Py.java2py(entry.getKey()), Py.java2py(entry.getValue())));
            }
            return items;
        }
    };
    private static final PyBuiltinMethodNarrow mapCopyProxy = new MapMethod("copy", 0){

        @Override
        public PyObject __call__() {
            Map jclone;
            Map<Object, Object> jmap = this.asMap();
            try {
                jclone = (Map)jmap.getClass().newInstance();
            }
            catch (IllegalAccessException e) {
                throw Py.JavaError(e);
            }
            catch (InstantiationException e) {
                throw Py.JavaError(e);
            }
            for (Map.Entry<Object, Object> entry : jmap.entrySet()) {
                jclone.put(entry.getKey(), entry.getValue());
            }
            return Py.java2py(jclone);
        }
    };
    private static final PyBuiltinMethodNarrow mapUpdateProxy = new MapMethod("update", 0, 1){
        private Map<Object, Object> jmap;

        @Override
        public PyObject __call__() {
            return Py.None;
        }

        @Override
        public PyObject __call__(PyObject other) {
            return this.__call__(new PyObject[]{other}, new String[0]);
        }

        @Override
        public PyObject __call__(PyObject[] args, String[] keywords) {
            if (args.length - keywords.length != 1) {
                throw this.info.unexpectedCall(args.length, false);
            }
            this.jmap = this.asMap();
            PyObject other = args[0];
            Object proxy = other.getJavaProxy();
            if (proxy instanceof Map) {
                this.merge((Map)proxy);
            } else if (other.__findattr__("keys") != null) {
                this.merge(other);
            } else {
                this.mergeFromSeq(other);
            }
            for (int i = 0; i < keywords.length; ++i) {
                String jkey = keywords[i];
                PyObject value = args[1 + i];
                this.jmap.put(jkey, Py.tojava(value, Object.class));
            }
            return Py.None;
        }

        private void merge(Map<Object, Object> other) {
            for (Map.Entry<Object, Object> entry : other.entrySet()) {
                this.jmap.put(entry.getKey(), entry.getValue());
            }
        }

        private void merge(PyObject other) {
            if (other instanceof PyDictionary) {
                this.jmap.putAll(((PyDictionary)other).getMap());
            } else if (other instanceof PyStringMap) {
                this.mergeFromKeys(other, ((PyStringMap)other).keys());
            } else {
                this.mergeFromKeys(other, other.invoke("keys"));
            }
        }

        private void mergeFromKeys(PyObject other, PyObject keys) {
            for (PyObject key : keys.asIterable()) {
                this.jmap.put(Py.tojava(key, Object.class), Py.tojava(other.__getitem__(key), Object.class));
            }
        }

        private void mergeFromSeq(PyObject other) {
            PyObject pair;
            PyObject pairs = other.__iter__();
            int i = 0;
            while ((pair = pairs.__iternext__()) != null) {
                try {
                    pair = PySequence.fastSequence(pair, "");
                }
                catch (PyException pye) {
                    if (pye.match(Py.TypeError)) {
                        throw Py.TypeError(String.format("cannot convert dictionary update sequence element #%d to a sequence", i));
                    }
                    throw pye;
                }
                int n = pair.__len__();
                if (n != 2) {
                    throw Py.ValueError(String.format("dictionary update sequence element #%d has length %d; 2 is required", i, n));
                }
                this.jmap.put(Py.tojava(pair.__getitem__(0), Object.class), Py.tojava(pair.__getitem__(1), Object.class));
                ++i;
            }
        }
    };
    private static final PyBuiltinClassMethodNarrow mapFromKeysProxy = new MapClassMethod("fromkeys", 1, 2){

        @Override
        public PyObject __call__(PyObject keys) {
            return this.__call__(keys, null);
        }

        @Override
        public PyObject __call__(PyObject keys, PyObject _default) {
            PyObject defobj = _default == null ? Py.None : Py.tojava(_default, Object.class);
            Class<?> theClass = this.asClass();
            try {
                Map theMap = (Map)theClass.newInstance();
                for (PyObject key : keys.asIterable()) {
                    theMap.put(Py.tojava(key, Object.class), defobj);
                }
                return Py.java2py(theMap);
            }
            catch (InstantiationException e) {
                throw Py.JavaError(e);
            }
            catch (IllegalAccessException e) {
                throw Py.JavaError(e);
            }
        }
    };

    JavaProxyMap() {
    }

    private static PyObject mapEq(PyObject self, PyObject other) {
        Map selfMap = (Map)self.getJavaProxy();
        if (other.getType().isSubType(PyDictionary.TYPE)) {
            PyDictionary oDict = (PyDictionary)other;
            if (selfMap.size() != oDict.size()) {
                return Py.False;
            }
            for (Object jkey : selfMap.keySet()) {
                Object jval = selfMap.get(jkey);
                PyObject oVal = oDict.__finditem__(Py.java2py(jkey));
                if (oVal == null) {
                    return Py.False;
                }
                if (Py.java2py(jval)._eq(oVal).__nonzero__()) continue;
                return Py.False;
            }
            return Py.True;
        }
        Object oj = other.getJavaProxy();
        if (oj instanceof Map) {
            Map oMap = (Map)oj;
            return Py.newBoolean(selfMap.equals(oMap));
        }
        return null;
    }

    private static PyObject mapLe(PyObject self, PyObject other) {
        Set selfKeys = ((Map)self.getJavaProxy()).keySet();
        if (other.getType().isSubType(PyDictionary.TYPE)) {
            PyDictionary oDict = (PyDictionary)other;
            for (Object jkey : selfKeys) {
                if (oDict.__contains__(Py.java2py(jkey))) continue;
                return Py.False;
            }
            return Py.True;
        }
        Object oj = other.getJavaProxy();
        if (oj instanceof Map) {
            Map oMap = (Map)oj;
            return Py.newBoolean(oMap.keySet().containsAll(selfKeys));
        }
        return null;
    }

    static PyBuiltinMethod[] getProxyMethods() {
        return new PyBuiltinMethod[]{mapLenProxy, mapIterProxy, mapReprProxy, mapEqProxy, mapLeProxy, mapLtProxy, mapGeProxy, mapGtProxy, mapContainsProxy, mapGetItemProxy, mapPutProxy, mapRemoveProxy, mapIterItemsProxy, mapHasKeyProxy, mapKeysProxy, mapSetDefaultProxy, mapPopProxy, mapPopItemProxy, mapItemsProxy, mapCopyProxy, mapUpdateProxy, mapFromKeysProxy};
    }

    static PyBuiltinMethod[] getPostProxyMethods() {
        return new PyBuiltinMethod[]{mapGetProxy, mapValuesProxy};
    }

    @Untraversable
    private static class MapClassMethod
    extends PyBuiltinClassMethodNarrow {
        protected MapClassMethod(String name, int minArgs, int maxArgs) {
            super(name, minArgs, maxArgs);
        }

        protected Class<?> asClass() {
            return (Class)this.self.getJavaProxy();
        }
    }

    @Untraversable
    private static class MapMethod
    extends PyBuiltinMethodNarrow {
        protected MapMethod(String name, int numArgs) {
            super(name, numArgs);
        }

        protected MapMethod(String name, int minArgs, int maxArgs) {
            super(name, minArgs, maxArgs);
        }

        protected Map<Object, Object> asMap() {
            return (Map)this.self.getJavaProxy();
        }
    }
}

