/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.python.bouncycastle.asn1.ASN1Encodable;
import org.python.bouncycastle.asn1.ASN1EncodableVector;
import org.python.bouncycastle.asn1.ASN1InputStream;
import org.python.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.python.bouncycastle.asn1.ASN1Set;
import org.python.bouncycastle.asn1.BEROctetStringGenerator;
import org.python.bouncycastle.asn1.BERSet;
import org.python.bouncycastle.asn1.DERSet;
import org.python.bouncycastle.asn1.DERTaggedObject;
import org.python.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.python.bouncycastle.asn1.cms.ContentInfo;
import org.python.bouncycastle.asn1.cms.OtherRevocationInfoFormat;
import org.python.bouncycastle.asn1.ocsp.OCSPResponse;
import org.python.bouncycastle.asn1.x509.Certificate;
import org.python.bouncycastle.asn1.x509.CertificateList;
import org.python.bouncycastle.cert.X509AttributeCertificateHolder;
import org.python.bouncycastle.cert.X509CRLHolder;
import org.python.bouncycastle.cert.X509CertificateHolder;
import org.python.bouncycastle.cms.CMSException;
import org.python.bouncycastle.cms.NullOutputStream;
import org.python.bouncycastle.cms.SignerInfoGenerator;
import org.python.bouncycastle.operator.DigestCalculator;
import org.python.bouncycastle.util.Store;
import org.python.bouncycastle.util.io.Streams;
import org.python.bouncycastle.util.io.TeeInputStream;
import org.python.bouncycastle.util.io.TeeOutputStream;

class CMSUtils {
    CMSUtils() {
    }

    static ContentInfo readContentInfo(byte[] byArray) throws CMSException {
        return CMSUtils.readContentInfo(new ASN1InputStream(byArray));
    }

    static ContentInfo readContentInfo(InputStream inputStream) throws CMSException {
        return CMSUtils.readContentInfo(new ASN1InputStream(inputStream));
    }

    static List getCertificatesFromStore(Store store) throws CMSException {
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        try {
            for (X509CertificateHolder x509CertificateHolder : store.getMatches(null)) {
                arrayList.add(x509CertificateHolder.toASN1Structure());
            }
            return arrayList;
        }
        catch (ClassCastException classCastException) {
            throw new CMSException("error processing certs", classCastException);
        }
    }

    static List getAttributeCertificatesFromStore(Store store) throws CMSException {
        ArrayList<DERTaggedObject> arrayList = new ArrayList<DERTaggedObject>();
        try {
            for (X509AttributeCertificateHolder x509AttributeCertificateHolder : store.getMatches(null)) {
                arrayList.add(new DERTaggedObject(false, 2, x509AttributeCertificateHolder.toASN1Structure()));
            }
            return arrayList;
        }
        catch (ClassCastException classCastException) {
            throw new CMSException("error processing certs", classCastException);
        }
    }

    static List getCRLsFromStore(Store store) throws CMSException {
        ArrayList<CertificateList> arrayList = new ArrayList<CertificateList>();
        try {
            for (X509CRLHolder x509CRLHolder : store.getMatches(null)) {
                arrayList.add(x509CRLHolder.toASN1Structure());
            }
            return arrayList;
        }
        catch (ClassCastException classCastException) {
            throw new CMSException("error processing certs", classCastException);
        }
    }

    static Collection getOthersFromStore(ASN1ObjectIdentifier aSN1ObjectIdentifier, Store store) {
        ArrayList<DERTaggedObject> arrayList = new ArrayList<DERTaggedObject>();
        for (ASN1Encodable aSN1Encodable : store.getMatches(null)) {
            OCSPResponse oCSPResponse;
            if (CMSObjectIdentifiers.id_ri_ocsp_response.equals(aSN1ObjectIdentifier) && (oCSPResponse = OCSPResponse.getInstance(aSN1Encodable)).getResponseStatus().getValue().intValue() != 0) {
                throw new IllegalArgumentException("cannot add unsuccessful OCSP response to CMS SignedData");
            }
            arrayList.add(new DERTaggedObject(false, 1, new OtherRevocationInfoFormat(aSN1ObjectIdentifier, aSN1Encodable)));
        }
        return arrayList;
    }

    static ASN1Set createBerSetFromList(List list) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            aSN1EncodableVector.add((ASN1Encodable)iterator.next());
        }
        return new BERSet(aSN1EncodableVector);
    }

    static ASN1Set createDerSetFromList(List list) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            aSN1EncodableVector.add((ASN1Encodable)iterator.next());
        }
        return new DERSet(aSN1EncodableVector);
    }

    static OutputStream createBEROctetOutputStream(OutputStream outputStream, int n, boolean bl, int n2) throws IOException {
        BEROctetStringGenerator bEROctetStringGenerator = new BEROctetStringGenerator(outputStream, n, bl);
        if (n2 != 0) {
            return bEROctetStringGenerator.getOctetOutputStream(new byte[n2]);
        }
        return bEROctetStringGenerator.getOctetOutputStream();
    }

    private static ContentInfo readContentInfo(ASN1InputStream aSN1InputStream) throws CMSException {
        try {
            return ContentInfo.getInstance(aSN1InputStream.readObject());
        }
        catch (IOException iOException) {
            throw new CMSException("IOException reading content.", iOException);
        }
        catch (ClassCastException classCastException) {
            throw new CMSException("Malformed content.", classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("Malformed content.", illegalArgumentException);
        }
    }

    public static byte[] streamToByteArray(InputStream inputStream) throws IOException {
        return Streams.readAll(inputStream);
    }

    public static byte[] streamToByteArray(InputStream inputStream, int n) throws IOException {
        return Streams.readAllLimited(inputStream, n);
    }

    static InputStream attachDigestsToInputStream(Collection collection, InputStream inputStream) {
        InputStream inputStream2 = inputStream;
        for (DigestCalculator digestCalculator : collection) {
            inputStream2 = new TeeInputStream(inputStream2, digestCalculator.getOutputStream());
        }
        return inputStream2;
    }

    static OutputStream attachSignersToOutputStream(Collection collection, OutputStream outputStream) {
        OutputStream outputStream2 = outputStream;
        for (SignerInfoGenerator signerInfoGenerator : collection) {
            outputStream2 = CMSUtils.getSafeTeeOutputStream(outputStream2, signerInfoGenerator.getCalculatingOutputStream());
        }
        return outputStream2;
    }

    static OutputStream getSafeOutputStream(OutputStream outputStream) {
        return outputStream == null ? new NullOutputStream() : outputStream;
    }

    static OutputStream getSafeTeeOutputStream(OutputStream outputStream, OutputStream outputStream2) {
        return outputStream == null ? CMSUtils.getSafeOutputStream(outputStream2) : (outputStream2 == null ? CMSUtils.getSafeOutputStream(outputStream) : new TeeOutputStream(outputStream, outputStream2));
    }
}

