/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm.node;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.rm.node.AMNode;
import org.apache.tez.dag.app.rm.node.AMNodeEvent;
import org.apache.tez.dag.app.rm.node.AMNodeEventNodeCountUpdated;
import org.apache.tez.dag.app.rm.node.AMNodeEventType;
import org.apache.tez.dag.app.rm.node.AMNodeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMNodeTracker
extends AbstractService
implements EventHandler<AMNodeEvent> {
    static final Logger LOG = LoggerFactory.getLogger(AMNodeTracker.class);
    private final ConcurrentHashMap<NodeId, AMNode> nodeMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Set<NodeId>> blacklistMap = new ConcurrentHashMap();
    private final EventHandler eventHandler;
    private final AppContext appContext;
    private int numClusterNodes;
    private boolean ignoreBlacklisting = false;
    private int maxTaskFailuresPerNode;
    private boolean nodeBlacklistingEnabled;
    private int blacklistDisablePercent;
    float currentIgnoreBlacklistingCountThreshold = 0.0f;

    public AMNodeTracker(EventHandler eventHandler, AppContext appContext) {
        super("AMNodeMap");
        this.eventHandler = eventHandler;
        this.appContext = appContext;
    }

    public synchronized void serviceInit(Configuration conf) {
        this.maxTaskFailuresPerNode = conf.getInt("tez.am.maxtaskfailures.per.node", 10);
        this.nodeBlacklistingEnabled = conf.getBoolean("tez.am.node-blacklisting.enabled", true);
        this.blacklistDisablePercent = conf.getInt("tez.am.node-blacklisting.ignore-threshold-node-percent", 33);
        LOG.info("blacklistDisablePercent is " + this.blacklistDisablePercent + ", blacklistingEnabled: " + this.nodeBlacklistingEnabled + ", maxTaskFailuresPerNode: " + this.maxTaskFailuresPerNode);
        if (this.blacklistDisablePercent < -1 || this.blacklistDisablePercent > 100) {
            throw new TezUncheckedException("Invalid blacklistDisablePercent: " + this.blacklistDisablePercent + ". Should be an integer between 0 and 100 or -1 to disabled");
        }
    }

    public void nodeSeen(NodeId nodeId) {
        if (this.nodeMap.putIfAbsent(nodeId, new AMNodeImpl(nodeId, this.maxTaskFailuresPerNode, this.eventHandler, this.nodeBlacklistingEnabled, this.appContext)) == null) {
            LOG.info("Adding new node: " + nodeId);
        }
    }

    private void addToBlackList(NodeId nodeId) {
        Set<NodeId> nodes;
        String host = nodeId.getHost();
        if (!this.blacklistMap.containsKey(host)) {
            this.blacklistMap.putIfAbsent(host, new HashSet());
        }
        if (!(nodes = this.blacklistMap.get(host)).contains(nodeId)) {
            nodes.add(nodeId);
        }
    }

    boolean registerBadNodeAndShouldBlacklist(AMNode amNode) {
        if (this.nodeBlacklistingEnabled) {
            this.addToBlackList(amNode.getNodeId());
            this.computeIgnoreBlacklisting();
            return !this.ignoreBlacklisting;
        }
        return false;
    }

    public void handle(AMNodeEvent rEvent) {
        NodeId nodeId = rEvent.getNodeId();
        switch ((AMNodeEventType)rEvent.getType()) {
            case N_NODE_COUNT_UPDATED: {
                AMNodeEventNodeCountUpdated event = (AMNodeEventNodeCountUpdated)rEvent;
                this.numClusterNodes = event.getNodeCount();
                LOG.info("Num cluster nodes = " + this.numClusterNodes);
                this.recomputeCurrentIgnoreBlacklistingThreshold();
                this.computeIgnoreBlacklisting();
                break;
            }
            case N_TURNED_UNHEALTHY: 
            case N_TURNED_HEALTHY: {
                AMNode amNode = this.nodeMap.get(nodeId);
                if (amNode == null) {
                    LOG.info("Ignoring RM Health Update for unknown node: " + nodeId);
                    break;
                }
                amNode.handle((Event)rEvent);
                break;
            }
            default: {
                this.nodeMap.get(nodeId).handle((Event)rEvent);
            }
        }
    }

    private void recomputeCurrentIgnoreBlacklistingThreshold() {
        if (this.nodeBlacklistingEnabled && this.blacklistDisablePercent != -1) {
            this.currentIgnoreBlacklistingCountThreshold = (float)this.numClusterNodes * (float)this.blacklistDisablePercent / 100.0f;
        }
    }

    protected void computeIgnoreBlacklisting() {
        boolean stateChanged = false;
        if (!this.nodeBlacklistingEnabled || this.blacklistDisablePercent == -1 || this.blacklistMap.size() == 0) {
            return;
        }
        if ((float)this.blacklistMap.size() >= this.currentIgnoreBlacklistingCountThreshold) {
            if (!this.ignoreBlacklisting) {
                this.ignoreBlacklisting = true;
                LOG.info("Ignore Blacklisting set to true. Known: " + this.numClusterNodes + ", Blacklisted: " + this.blacklistMap.size());
                stateChanged = true;
            }
        } else if (this.ignoreBlacklisting) {
            this.ignoreBlacklisting = false;
            LOG.info("Ignore blacklisting set to false. Known: " + this.numClusterNodes + ", Blacklisted: " + this.blacklistMap.size());
            stateChanged = true;
        }
        if (stateChanged) {
            this.sendIngoreBlacklistingStateToNodes();
        }
    }

    private void sendIngoreBlacklistingStateToNodes() {
        AMNodeEventType eventType = this.ignoreBlacklisting ? AMNodeEventType.N_IGNORE_BLACKLISTING_ENABLED : AMNodeEventType.N_IGNORE_BLACKLISTING_DISABLED;
        for (NodeId nodeId : this.nodeMap.keySet()) {
            this.sendEvent((Event<?>)new AMNodeEvent(nodeId, eventType));
        }
    }

    public AMNode get(NodeId nodeId) {
        return this.nodeMap.get(nodeId);
    }

    private void sendEvent(Event<?> event) {
        this.eventHandler.handle(event);
    }

    public int getNumNodes() {
        return this.nodeMap.size();
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public boolean isBlacklistingIgnored() {
        return this.ignoreBlacklisting;
    }

    public void dagComplete(DAG dag) {
    }
}

