/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.streaming.Environment;
import org.apache.hadoop.streaming.PathFinder;
import org.apache.hadoop.streaming.StreamKeyValUtil;
import org.apache.hadoop.streaming.StreamUtil;
import org.apache.hadoop.util.LineReader;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.UTF8ByteArrayUtils;

public abstract class PipeMapRed {
    protected static final Log LOG = LogFactory.getLog((String)PipeMapRed.class.getName());
    static final int OUTSIDE = 1;
    static final int SINGLEQ = 2;
    static final int DOUBLEQ = 3;
    private static final int BUFFER_SIZE = 131072;
    long startTime_;
    long numRecRead_ = 0L;
    long numRecWritten_ = 0L;
    long numRecSkipped_ = 0L;
    long nextRecReadLog_ = 1L;
    long minRecWrittenToEnableSkip_ = Long.MAX_VALUE;
    long reporterOutDelay_ = 10000L;
    long reporterErrDelay_ = 10000L;
    long joinDelay_;
    JobConf job_;
    FileSystem fs_;
    boolean doPipe_;
    boolean debug_;
    boolean debugFailEarly_;
    boolean debugFailDuring_;
    boolean debugFailLate_;
    boolean nonZeroExitIsFailure_;
    Process sim;
    MROutputThread outThread_;
    String jobLog_;
    MRErrorThread errThread_;
    DataOutputStream clientOut_;
    DataInputStream clientErr_;
    DataInputStream clientIn_;
    String mapredKey_;
    int numExceptions_;
    StreamUtil.TaskId taskId_;
    protected volatile Throwable outerrThreadsThrowable;
    String LOGNAME;
    PrintStream log_;
    volatile boolean processProvidedStatus_ = false;

    abstract String getPipeCommand(JobConf var1);

    abstract byte[] getFieldSeparator();

    abstract int getNumOfKeyFields();

    abstract boolean getDoPipe();

    static String[] splitArgs(String args) {
        ArrayList<String> argList = new ArrayList<String>();
        char[] ch = args.toCharArray();
        int clen = ch.length;
        int state = 1;
        int argstart = 0;
        for (int c = 0; c <= clen; ++c) {
            boolean last = c == clen;
            int lastState = state;
            boolean endToken = false;
            if (!last) {
                if (ch[c] == '\'') {
                    if (state == 1) {
                        state = 2;
                    } else if (state == 2) {
                        state = 1;
                    }
                    endToken = state != lastState;
                } else if (ch[c] == '\"') {
                    if (state == 1) {
                        state = 3;
                    } else if (state == 3) {
                        state = 1;
                    }
                    endToken = state != lastState;
                } else if (ch[c] == ' ' && state == 1) {
                    endToken = true;
                }
            }
            if (!last && !endToken) continue;
            if (c != argstart) {
                String a = args.substring(argstart, c);
                argList.add(a);
            }
            argstart = c + 1;
            lastState = state;
        }
        return argList.toArray(new String[0]);
    }

    public void configure(JobConf job) {
        try {
            String argv = this.getPipeCommand(job);
            this.joinDelay_ = job.getLong("stream.joindelay.milli", 0L);
            this.job_ = job;
            this.fs_ = FileSystem.get((Configuration)this.job_);
            this.nonZeroExitIsFailure_ = this.job_.getBoolean("stream.non.zero.exit.is.failure", true);
            this.doPipe_ = this.getDoPipe();
            if (!this.doPipe_) {
                return;
            }
            this.setStreamJobDetails(job);
            String[] argvSplit = PipeMapRed.splitArgs(argv);
            String prog = argvSplit[0];
            File currentDir = new File(".").getAbsoluteFile();
            if (!new File(prog).isAbsolute()) {
                FileUtil.chmod((String)new File(currentDir, prog).toString(), (String)"a+x");
            }
            if (!new File(argvSplit[0]).isAbsolute()) {
                PathFinder finder = new PathFinder("PATH");
                finder.prependPathComponent(currentDir.toString());
                File f = finder.getAbsolutePath(argvSplit[0]);
                if (f != null) {
                    argvSplit[0] = f.getAbsolutePath();
                }
                f = null;
            }
            this.logprintln("PipeMapRed exec " + Arrays.asList(argvSplit));
            Environment childEnv = (Environment)StreamUtil.env().clone();
            this.addJobConfToEnvironment(this.job_, childEnv);
            this.addEnvironment(childEnv, this.job_.get("stream.addenvironment"));
            this.envPut(childEnv, "TMPDIR", System.getProperty("java.io.tmpdir"));
            ProcessBuilder builder = new ProcessBuilder(argvSplit);
            builder.environment().putAll(childEnv.toMap());
            this.sim = builder.start();
            this.clientOut_ = new DataOutputStream(new BufferedOutputStream(this.sim.getOutputStream(), 131072));
            this.clientIn_ = new DataInputStream(new BufferedInputStream(this.sim.getInputStream(), 131072));
            this.clientErr_ = new DataInputStream(new BufferedInputStream(this.sim.getErrorStream()));
            this.startTime_ = System.currentTimeMillis();
            this.errThread_ = new MRErrorThread();
            this.errThread_.start();
        }
        catch (Exception e) {
            this.logStackTrace(e);
            LOG.error((Object)"configuration exception", (Throwable)e);
            throw new RuntimeException("configuration exception", e);
        }
    }

    void setStreamJobDetails(JobConf job) {
        this.jobLog_ = job.get("stream.jobLog_");
        String s = job.get("stream.minRecWrittenToEnableSkip_");
        if (s != null) {
            this.minRecWrittenToEnableSkip_ = Long.parseLong(s);
            this.logprintln("JobConf set minRecWrittenToEnableSkip_ =" + this.minRecWrittenToEnableSkip_);
        }
        this.taskId_ = StreamUtil.getTaskInfo(this.job_);
    }

    void logStackTrace(Exception e) {
        if (e == null) {
            return;
        }
        e.printStackTrace();
        if (this.log_ != null) {
            e.printStackTrace(this.log_);
        }
    }

    void logprintln(String s) {
        if (this.log_ != null) {
            this.log_.println(s);
        } else {
            LOG.info((Object)s);
        }
    }

    void logflush() {
        if (this.log_ != null) {
            this.log_.flush();
        }
    }

    void addJobConfToEnvironment(JobConf conf, Properties env) {
        if (this.debug_) {
            this.logprintln("addJobConfToEnvironment: begin");
        }
        for (Map.Entry en : conf) {
            String name = (String)en.getKey();
            String value = conf.get(name);
            name = this.safeEnvVarName(name);
            this.envPut(env, name, value);
        }
        if (this.debug_) {
            this.logprintln("addJobConfToEnvironment: end");
        }
    }

    String safeEnvVarName(String var) {
        StringBuffer safe = new StringBuffer();
        int len = var.length();
        for (int i = 0; i < len; ++i) {
            int c = var.charAt(i);
            int s = c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122 ? c : 95;
            safe.append((char)s);
        }
        return safe.toString();
    }

    void addEnvironment(Properties env, String nameVals) {
        if (nameVals == null) {
            return;
        }
        String[] nv = nameVals.split(" ");
        for (int i = 0; i < nv.length; ++i) {
            String[] pair = nv[i].split("=", 2);
            if (pair.length != 2) {
                this.logprintln("Skip ev entry:" + nv[i]);
                continue;
            }
            this.envPut(env, pair[0], pair[1]);
        }
    }

    void envPut(Properties env, String name, String value) {
        if (this.debug_) {
            this.logprintln("Add  ev entry:" + name + "=" + value);
        }
        env.put(name, value);
    }

    void appendLogToJobLog(String status) {
        if (this.jobLog_ == null) {
            return;
        }
        if (this.log_ != null) {
            StreamUtil.exec("/bin/rm " + this.LOGNAME, this.log_);
        }
    }

    void startOutputThreads(OutputCollector output, Reporter reporter) {
        this.outThread_ = new MROutputThread(output, reporter);
        this.outThread_.start();
        this.errThread_.setReporter(reporter);
    }

    void waitOutputThreads() {
        try {
            int exitVal;
            if (this.outThread_ == null) {
                OutputCollector collector = new OutputCollector(){

                    public void collect(Object key, Object value) throws IOException {
                    }
                };
                Reporter reporter = Reporter.NULL;
                this.startOutputThreads(collector, reporter);
            }
            if ((exitVal = this.sim.waitFor()) != 0) {
                if (this.nonZeroExitIsFailure_) {
                    throw new RuntimeException("PipeMapRed.waitOutputThreads(): subprocess failed with code " + exitVal);
                }
                this.logprintln("PipeMapRed.waitOutputThreads(): subprocess exited with code " + exitVal + " in " + PipeMapRed.class.getName());
            }
            if (this.outThread_ != null) {
                this.outThread_.join(this.joinDelay_);
            }
            if (this.errThread_ != null) {
                this.errThread_.join(this.joinDelay_);
            }
            if (this.outerrThreadsThrowable != null) {
                throw new RuntimeException(this.outerrThreadsThrowable);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void splitKeyVal(byte[] line, int length, Text key, Text val) throws IOException {
        int numKeyFields = this.getNumOfKeyFields();
        byte[] separator = this.getFieldSeparator();
        int pos = UTF8ByteArrayUtils.findBytes((byte[])line, (int)0, (int)length, (byte[])separator);
        for (int k = 1; k < numKeyFields && pos != -1; ++k) {
            pos = UTF8ByteArrayUtils.findBytes((byte[])line, (int)(pos + separator.length), (int)length, (byte[])separator);
        }
        try {
            if (pos == -1) {
                key.set(line, 0, length);
                val.set("");
            } else {
                StreamKeyValUtil.splitKeyVal(line, 0, length, key, val, pos, separator.length);
            }
        }
        catch (CharacterCodingException e) {
            LOG.warn((Object)StringUtils.stringifyException((Throwable)e));
        }
    }

    public void mapRedFinished() {
        try {
            if (!this.doPipe_) {
                this.logprintln("mapRedFinished");
                return;
            }
            try {
                if (this.clientOut_ != null) {
                    this.clientOut_.flush();
                    this.clientOut_.close();
                }
            }
            catch (IOException io) {
                // empty catch block
            }
            this.waitOutputThreads();
            if (this.sim != null) {
                this.sim.destroy();
            }
            this.logprintln("mapRedFinished");
        }
        catch (RuntimeException e) {
            this.logprintln("PipeMapRed failed!");
            this.logStackTrace(e);
            throw e;
        }
        if (this.debugFailLate_) {
            throw new RuntimeException("debugFailLate_");
        }
    }

    void maybeLogRecord() {
        if (this.numRecRead_ >= this.nextRecReadLog_) {
            String info = this.numRecInfo();
            this.logprintln(info);
            this.logflush();
            this.nextRecReadLog_ = this.nextRecReadLog_ < 100000L ? (this.nextRecReadLog_ *= 10L) : (this.nextRecReadLog_ += 100000L);
        }
    }

    public String getContext() {
        String s = this.numRecInfo() + "\n";
        s = s + "minRecWrittenToEnableSkip_=" + this.minRecWrittenToEnableSkip_ + " ";
        s = s + "LOGNAME=" + this.LOGNAME + "\n";
        s = s + this.envline("HOST");
        s = s + this.envline("USER");
        s = s + this.envline("HADOOP_USER");
        s = s + "last Hadoop input: |" + this.mapredKey_ + "|\n";
        if (this.outThread_ != null) {
            s = s + "last tool output: |" + this.outThread_.answer + "|\n";
        }
        s = s + "Date: " + new Date() + "\n";
        return s;
    }

    String envline(String var) {
        return var + "=" + StreamUtil.env().get(var) + "\n";
    }

    String numRecInfo() {
        long elapsed = (System.currentTimeMillis() - this.startTime_) / 1000L;
        return "R/W/S=" + this.numRecRead_ + "/" + this.numRecWritten_ + "/" + this.numRecSkipped_ + " in:" + this.safeDiv(this.numRecRead_, elapsed) + " [rec/s]" + " out:" + this.safeDiv(this.numRecWritten_, elapsed) + " [rec/s]";
    }

    String safeDiv(long n, long d) {
        return d == 0L ? "NA" : "" + n / d + "=" + n + "/" + d;
    }

    String logFailure(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        String msg = "log:" + this.jobLog_ + "\n" + this.getContext() + sw + "\n";
        this.logprintln(msg);
        return msg;
    }

    void write(Object value) throws IOException {
        int valSize;
        byte[] bval;
        if (value instanceof BytesWritable) {
            BytesWritable val = (BytesWritable)value;
            bval = val.getBytes();
            valSize = val.getLength();
        } else if (value instanceof Text) {
            Text val = (Text)value;
            bval = val.getBytes();
            valSize = val.getLength();
        } else {
            String sval = value.toString();
            bval = sval.getBytes("UTF-8");
            valSize = bval.length;
        }
        this.clientOut_.write(bval, 0, valSize);
    }

    class MRErrorThread
    extends Thread {
        long lastStderrReport = 0L;
        volatile Reporter reporter;
        private final String reporterPrefix;
        private final String counterPrefix;
        private final String statusPrefix;

        public MRErrorThread() {
            this.reporterPrefix = PipeMapRed.this.job_.get("stream.stderr.reporter.prefix", "reporter:");
            this.counterPrefix = this.reporterPrefix + "counter:";
            this.statusPrefix = this.reporterPrefix + "status:";
            this.setDaemon(true);
        }

        public void setReporter(Reporter reporter) {
            this.reporter = reporter;
        }

        @Override
        public void run() {
            Text line = new Text();
            LineReader lineReader = null;
            try {
                lineReader = new LineReader((InputStream)PipeMapRed.this.clientErr_, (Configuration)PipeMapRed.this.job_);
                while (lineReader.readLine(line) > 0) {
                    String lineStr = line.toString();
                    if (this.matchesReporter(lineStr)) {
                        if (this.matchesCounter(lineStr)) {
                            this.incrCounter(lineStr);
                        } else if (this.matchesStatus(lineStr)) {
                            PipeMapRed.this.processProvidedStatus_ = true;
                            this.setStatus(lineStr);
                        } else {
                            LOG.warn((Object)("Cannot parse reporter line: " + lineStr));
                        }
                    } else {
                        System.err.println(lineStr);
                    }
                    long now = System.currentTimeMillis();
                    if (this.reporter != null && now - this.lastStderrReport > PipeMapRed.this.reporterErrDelay_) {
                        this.lastStderrReport = now;
                        this.reporter.progress();
                    }
                    line.clear();
                }
                if (lineReader != null) {
                    lineReader.close();
                }
                if (PipeMapRed.this.clientErr_ != null) {
                    PipeMapRed.this.clientErr_.close();
                    PipeMapRed.this.clientErr_ = null;
                    LOG.info((Object)"MRErrorThread done");
                }
            }
            catch (Throwable th) {
                PipeMapRed.this.outerrThreadsThrowable = th;
                LOG.warn((Object)StringUtils.stringifyException((Throwable)th));
                try {
                    if (lineReader != null) {
                        lineReader.close();
                    }
                    if (PipeMapRed.this.clientErr_ != null) {
                        PipeMapRed.this.clientErr_.close();
                        PipeMapRed.this.clientErr_ = null;
                    }
                }
                catch (IOException io) {
                    LOG.info((Object)StringUtils.stringifyException((Throwable)io));
                }
            }
        }

        private boolean matchesReporter(String line) {
            return line.startsWith(this.reporterPrefix);
        }

        private boolean matchesCounter(String line) {
            return line.startsWith(this.counterPrefix);
        }

        private boolean matchesStatus(String line) {
            return line.startsWith(this.statusPrefix);
        }

        private void incrCounter(String line) {
            String trimmedLine = line.substring(this.counterPrefix.length()).trim();
            String[] columns = trimmedLine.split(",");
            if (columns.length == 3) {
                try {
                    this.reporter.incrCounter(columns[0], columns[1], Long.parseLong(columns[2]));
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)("Cannot parse counter increment '" + columns[2] + "' from line: " + line));
                }
            } else {
                LOG.warn((Object)("Cannot parse counter line: " + line));
            }
        }

        private void setStatus(String line) {
            this.reporter.setStatus(line.substring(this.statusPrefix.length()).trim());
        }
    }

    class MROutputThread
    extends Thread {
        OutputCollector output;
        Reporter reporter;
        byte[] answer;
        long lastStdoutReport = 0L;

        MROutputThread(OutputCollector output, Reporter reporter) {
            this.setDaemon(true);
            this.output = output;
            this.reporter = reporter;
        }

        @Override
        public void run() {
            LineReader lineReader = null;
            try {
                Text key = new Text();
                Text val = new Text();
                Text line = new Text();
                lineReader = new LineReader((InputStream)PipeMapRed.this.clientIn_, (Configuration)PipeMapRed.this.job_);
                while (lineReader.readLine(line) > 0) {
                    this.answer = line.getBytes();
                    PipeMapRed.this.splitKeyVal(this.answer, line.getLength(), key, val);
                    this.output.collect((Object)key, (Object)val);
                    line.clear();
                    ++PipeMapRed.this.numRecWritten_;
                    long now = System.currentTimeMillis();
                    if (now - this.lastStdoutReport <= PipeMapRed.this.reporterOutDelay_) continue;
                    this.lastStdoutReport = now;
                    String hline = "Records R/W=" + PipeMapRed.this.numRecRead_ + "/" + PipeMapRed.this.numRecWritten_;
                    if (!PipeMapRed.this.processProvidedStatus_) {
                        this.reporter.setStatus(hline);
                    } else {
                        this.reporter.progress();
                    }
                    PipeMapRed.this.logprintln(hline);
                    PipeMapRed.this.logflush();
                }
                if (lineReader != null) {
                    lineReader.close();
                }
                if (PipeMapRed.this.clientIn_ != null) {
                    PipeMapRed.this.clientIn_.close();
                    PipeMapRed.this.clientIn_ = null;
                    LOG.info((Object)"MROutputThread done");
                }
            }
            catch (Throwable th) {
                PipeMapRed.this.outerrThreadsThrowable = th;
                LOG.warn((Object)StringUtils.stringifyException((Throwable)th));
                try {
                    if (lineReader != null) {
                        lineReader.close();
                    }
                    if (PipeMapRed.this.clientIn_ != null) {
                        PipeMapRed.this.clientIn_.close();
                        PipeMapRed.this.clientIn_ = null;
                    }
                }
                catch (IOException io) {
                    LOG.info((Object)StringUtils.stringifyException((Throwable)io));
                }
            }
        }
    }
}

