/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.newplan.BaseOperatorPlan;
import org.apache.pig.newplan.Operator;

public class PlanDumper {
    protected PrintStream ps;
    protected BaseOperatorPlan plan;
    protected boolean isVerbose = true;

    public PlanDumper(BaseOperatorPlan plan, PrintStream ps) {
        this.plan = plan;
        this.ps = ps;
    }

    public void setVerbose(boolean verbose) {
        this.isVerbose = verbose;
    }

    public boolean isVerbose() {
        return this.isVerbose;
    }

    public void dump() {
        Operator op;
        Iterator<Operator> iter = this.plan.getOperators();
        while (iter.hasNext()) {
            op = iter.next();
            MultiMap<Operator, BaseOperatorPlan> map = this.getMultiInputNestedPlans(op);
            if (this.isVerbose && !map.isEmpty()) {
                this.dumpMultiInputNestedOperator(op, map);
                continue;
            }
            Collection<BaseOperatorPlan> plans = this.getMultiOutputNestedPlans(op);
            if (plans.size() > 0) {
                this.dumpMultiOutputNestedOperator(op, plans);
                continue;
            }
            plans = this.getNestedPlans(op);
            if (this.isVerbose && plans.size() > 0) {
                this.dumpNestedOperator(op, plans);
                continue;
            }
            this.dumpOperator(op);
        }
        iter = this.plan.getOperators();
        while (iter.hasNext()) {
            op = iter.next();
            List<Operator> successors = this.plan.getSuccessors(op);
            if (successors == null) continue;
            for (Operator suc : successors) {
                this.dumpEdge(op, suc);
            }
        }
    }

    protected PlanDumper makeDumper(BaseOperatorPlan plan, PrintStream ps) {
        return new PlanDumper(plan, ps);
    }

    protected void dumpOperator(Operator op) {
        this.ps.println(op.getName().replace(" ", "_"));
    }

    protected void dumpMultiInputNestedOperator(Operator op, MultiMap<Operator, BaseOperatorPlan> plans) {
        this.dumpOperator(op);
        for (Operator aop : plans.keySet()) {
            for (BaseOperatorPlan plan : plans.get(aop)) {
                PlanDumper dumper = this.makeDumper(plan, this.ps);
                dumper.dump();
            }
        }
    }

    protected void dumpMultiOutputNestedOperator(Operator op, Collection<BaseOperatorPlan> plans) {
        this.dumpOperator(op);
        for (BaseOperatorPlan plan : plans) {
            PlanDumper dumper = this.makeDumper(plan, this.ps);
            dumper.dump();
            for (Operator p : plan.getSources()) {
                this.dumpEdge(op, p);
            }
        }
    }

    protected void dumpNestedOperator(Operator op, Collection<BaseOperatorPlan> plans) {
        this.dumpOperator(op);
        for (BaseOperatorPlan plan : plans) {
            PlanDumper dumper = this.makeDumper(plan, this.ps);
            dumper.dump();
        }
    }

    protected void dumpEdge(Operator op, Operator suc) {
        this.ps.println(op.getName() + " -> " + suc.getName());
    }

    protected MultiMap<Operator, BaseOperatorPlan> getMultiInputNestedPlans(Operator op) {
        return new MultiMap<Operator, BaseOperatorPlan>();
    }

    protected Collection<BaseOperatorPlan> getMultiOutputNestedPlans(Operator op) {
        return new LinkedList<BaseOperatorPlan>();
    }

    protected Collection<BaseOperatorPlan> getNestedPlans(Operator op) {
        return new LinkedList<BaseOperatorPlan>();
    }

    protected void join(String sep, String[] strings) {
        if (strings == null) {
            return;
        }
        for (int i = 0; i < strings.length; ++i) {
            if (i != 0) {
                this.ps.print(sep);
            }
            this.ps.print(strings[i]);
        }
    }
}

