/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanEdge;

public abstract class BaseOperatorPlan
implements OperatorPlan {
    protected List<Operator> ops;
    protected PlanEdge fromEdges;
    protected PlanEdge toEdges;
    protected PlanEdge softFromEdges;
    protected PlanEdge softToEdges;
    private List<Operator> roots;
    private List<Operator> leaves;
    protected static final Log log = LogFactory.getLog(BaseOperatorPlan.class);

    public BaseOperatorPlan() {
        this.ops = new ArrayList<Operator>();
        this.roots = new ArrayList<Operator>();
        this.leaves = new ArrayList<Operator>();
        this.fromEdges = new PlanEdge();
        this.toEdges = new PlanEdge();
        this.softFromEdges = new PlanEdge();
        this.softToEdges = new PlanEdge();
    }

    public BaseOperatorPlan(BaseOperatorPlan other) {
        this.ops = (List)((ArrayList)other.ops).clone();
        this.roots = (List)((ArrayList)other.roots).clone();
        this.leaves = (List)((ArrayList)other.leaves).clone();
        this.fromEdges = other.fromEdges.shallowClone();
        this.toEdges = other.toEdges.shallowClone();
        this.softFromEdges = other.softFromEdges.shallowClone();
        this.softToEdges = other.softToEdges.shallowClone();
    }

    @Override
    public int size() {
        return this.ops.size();
    }

    @Override
    public List<Operator> getSources() {
        if (this.roots.size() == 0 && this.ops.size() > 0) {
            for (Operator op : this.ops) {
                if (this.toEdges.get(op) != null) continue;
                this.roots.add(op);
            }
        }
        return this.roots;
    }

    @Override
    public List<Operator> getSinks() {
        if (this.leaves.size() == 0 && this.ops.size() > 0) {
            for (Operator op : this.ops) {
                if (this.fromEdges.get(op) != null) continue;
                this.leaves.add(op);
            }
        }
        return this.leaves;
    }

    @Override
    public List<Operator> getPredecessors(Operator op) {
        return this.toEdges.get(op);
    }

    @Override
    public List<Operator> getSuccessors(Operator op) {
        return this.fromEdges.get(op);
    }

    @Override
    public List<Operator> getSoftLinkPredecessors(Operator op) {
        return this.softToEdges.get(op);
    }

    @Override
    public List<Operator> getSoftLinkSuccessors(Operator op) {
        return this.softFromEdges.get(op);
    }

    @Override
    public void add(Operator op) {
        this.markDirty();
        if (!this.ops.contains(op)) {
            this.ops.add(op);
        }
    }

    @Override
    public void remove(Operator op) throws FrontendException {
        if (this.fromEdges.containsKey(op) || this.toEdges.containsKey(op)) {
            throw new FrontendException("Attempt to remove operator " + op.getName() + " that is still connected in the plan", 2243);
        }
        if (this.softFromEdges.containsKey(op) || this.softToEdges.containsKey(op)) {
            throw new FrontendException("Attempt to remove operator " + op.getName() + " that is still softly connected in the plan", 2243);
        }
        this.markDirty();
        this.ops.remove(op);
    }

    @Override
    public void connect(Operator from, int fromPos, Operator to, int toPos) {
        if (this.isConnected(from, to) || from == null || to == null) {
            return;
        }
        this.markDirty();
        this.fromEdges.put(from, to, fromPos);
        this.toEdges.put(to, from, toPos);
    }

    public boolean isConnected(Operator from, Operator to) {
        List<Operator> preds = this.getPredecessors(to);
        return preds != null && preds.contains(from);
    }

    @Override
    public void connect(Operator from, Operator to) {
        if (this.isConnected(from, to) || from == null || to == null) {
            return;
        }
        this.markDirty();
        this.fromEdges.put(from, to);
        this.toEdges.put(to, from);
    }

    @Override
    public void createSoftLink(Operator from, Operator to) {
        this.softFromEdges.put(from, to);
        this.softToEdges.put(to, from);
    }

    @Override
    public void removeSoftLink(Operator from, Operator to) {
        this.softFromEdges.remove(from, to);
        this.softToEdges.remove(to, from);
    }

    @Override
    public Pair<Integer, Integer> disconnect(Operator from, Operator to) throws FrontendException {
        Pair<Operator, Integer> f = this.fromEdges.removeWithPosition(from, to);
        if (f == null) {
            throw new FrontendException("Attempt to disconnect operators " + from.getName() + " and " + to.getName() + " which are not connected.", 2219);
        }
        Pair<Operator, Integer> t = this.toEdges.removeWithPosition(to, from);
        if (t == null) {
            throw new FrontendException("Plan in inconssistent state " + from.getName() + " and " + to.getName() + " connected in fromEdges but not toEdges.", 2220);
        }
        this.markDirty();
        return new Pair<Integer, Integer>((Integer)f.second, (Integer)t.second);
    }

    private void markDirty() {
        this.roots.clear();
        this.leaves.clear();
    }

    @Override
    public Iterator<Operator> getOperators() {
        return this.ops.iterator();
    }

    @Override
    public boolean isEqual(OperatorPlan other) throws FrontendException {
        return BaseOperatorPlan.isEqual(this, other);
    }

    private static boolean checkPredecessors(Operator op1, Operator op2) throws FrontendException {
        List<Operator> preds = op1.getPlan().getPredecessors(op1);
        List<Operator> otherPreds = op2.getPlan().getPredecessors(op2);
        if (preds != null || otherPreds != null) {
            if (preds == null || otherPreds == null) {
                return false;
            }
            if (preds.size() != otherPreds.size()) {
                return false;
            }
            for (int i = 0; i < preds.size(); ++i) {
                Operator p2;
                Operator p1 = preds.get(i);
                if (!p1.isEqual(p2 = otherPreds.get(i))) {
                    return false;
                }
                if (BaseOperatorPlan.checkPredecessors(p1, p2)) continue;
                return false;
            }
        }
        return true;
    }

    protected static boolean isEqual(OperatorPlan p1, OperatorPlan p2) throws FrontendException {
        if (p1 == p2) {
            return true;
        }
        if (p1 != null && p2 != null) {
            List<Operator> leaves = p1.getSinks();
            List<Operator> otherLeaves = p2.getSinks();
            if (leaves.size() != otherLeaves.size()) {
                return false;
            }
            boolean foundAll = true;
            for (Operator op1 : leaves) {
                boolean foundOne = false;
                for (Operator op2 : otherLeaves) {
                    if (!op1.isEqual(op2) || !BaseOperatorPlan.checkPredecessors(op1, op2)) continue;
                    foundOne = true;
                    break;
                }
                if (foundAll &= foundOne) continue;
                return false;
            }
            return foundAll;
        }
        return false;
    }

    public void explain(PrintStream ps, String format, boolean verbose) throws FrontendException {
    }

    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        try {
            this.explain(ps, "", false);
        }
        catch (FrontendException e) {
            return "";
        }
        return os.toString();
    }

    @Override
    public void replace(Operator oldOperator, Operator newOperator) throws FrontendException {
        List<Operator> succs;
        this.add(newOperator);
        List<Operator> preds = this.getPredecessors(oldOperator);
        if (preds != null) {
            ArrayList<Operator> predsCopy = new ArrayList<Operator>();
            predsCopy.addAll(preds);
            for (int i = 0; i < predsCopy.size(); ++i) {
                Operator pred = (Operator)predsCopy.get(i);
                Pair<Integer, Integer> pos = this.disconnect(pred, oldOperator);
                this.connect(pred, (Integer)pos.first, newOperator, i);
            }
        }
        if ((succs = this.getSuccessors(oldOperator)) != null) {
            ArrayList<Operator> succsCopy = new ArrayList<Operator>();
            succsCopy.addAll(succs);
            for (int i = 0; i < succsCopy.size(); ++i) {
                Operator succ = (Operator)succsCopy.get(i);
                Pair<Integer, Integer> pos = this.disconnect(oldOperator, succ);
                this.connect(newOperator, i, succ, (Integer)pos.second);
            }
        }
        this.remove(oldOperator);
    }

    @Override
    public void removeAndReconnect(Operator operatorToRemove) throws FrontendException {
        ArrayList<Operator> predsCopy = null;
        if (this.getPredecessors(operatorToRemove) != null && this.getPredecessors(operatorToRemove).size() != 0) {
            predsCopy = new ArrayList<Operator>();
            predsCopy.addAll(this.getPredecessors(operatorToRemove));
        }
        ArrayList<Operator> succsCopy = null;
        if (this.getSuccessors(operatorToRemove) != null && this.getSuccessors(operatorToRemove).size() != 0) {
            succsCopy = new ArrayList<Operator>();
            succsCopy.addAll(this.getSuccessors(operatorToRemove));
        }
        if (predsCopy != null && predsCopy.size() > 1 && succsCopy != null && succsCopy.size() > 1) {
            throw new FrontendException("Cannot remove and reconnect node with multiple inputs/outputs", 2256);
        }
        if (predsCopy != null && predsCopy.size() > 1) {
            Operator succ = null;
            Pair<Integer, Integer> pos2 = null;
            if (succsCopy != null) {
                succ = (Operator)succsCopy.get(0);
                pos2 = this.disconnect(operatorToRemove, succ);
            }
            for (Operator pred : predsCopy) {
                Pair<Integer, Integer> pos1 = this.disconnect(pred, operatorToRemove);
                if (succ == null) continue;
                this.connect(pred, (Integer)pos1.first, succ, (Integer)pos2.second);
            }
        } else if (succsCopy != null && succsCopy.size() > 1) {
            Operator pred = null;
            Pair<Integer, Integer> pos1 = null;
            if (predsCopy != null) {
                pred = (Operator)predsCopy.get(0);
                pos1 = this.disconnect(pred, operatorToRemove);
            }
            for (Operator succ : succsCopy) {
                Pair<Integer, Integer> pos2 = this.disconnect(operatorToRemove, succ);
                if (pred == null) continue;
                this.connect(pred, (Integer)pos1.first, succ, (Integer)pos2.second);
            }
        } else {
            Operator pred = null;
            Pair<Integer, Integer> pos1 = null;
            if (predsCopy != null) {
                pred = (Operator)predsCopy.get(0);
                pos1 = this.disconnect(pred, operatorToRemove);
            }
            Operator succ = null;
            Pair<Integer, Integer> pos2 = null;
            if (succsCopy != null) {
                succ = (Operator)succsCopy.get(0);
                pos2 = this.disconnect(operatorToRemove, succ);
            }
            if (pred != null && succ != null) {
                this.connect(pred, (Integer)pos1.first, succ, (Integer)pos2.second);
            }
        }
        this.remove(operatorToRemove);
    }

    @Override
    public void insertBetween(Operator pred, Operator operatorToInsert, Operator succ) throws FrontendException {
        this.add(operatorToInsert);
        Pair<Integer, Integer> pos = this.disconnect(pred, succ);
        this.connect(pred, (Integer)pos.first, operatorToInsert, 0);
        this.connect(operatorToInsert, 0, succ, (Integer)pos.second);
    }

    @Override
    public boolean pathExists(Operator from, Operator to) {
        List<Operator> successors = this.getSuccessors(from);
        if (successors == null || successors.size() == 0) {
            return false;
        }
        for (Operator successor : successors) {
            if (!successor.equals(to) && !this.pathExists(successor, to)) continue;
            return true;
        }
        return false;
    }

    public void moveTree(Operator root, BaseOperatorPlan newPlan) throws FrontendException {
        ArrayDeque<Operator> queue = new ArrayDeque<Operator>();
        newPlan.add(root);
        root.setPlan(newPlan);
        queue.addLast(root);
        while (!queue.isEmpty()) {
            Operator node = (Operator)queue.poll();
            if (this.getSuccessors(node) == null) continue;
            for (Operator succ : this.getSuccessors(node)) {
                if (queue.contains(succ)) continue;
                queue.addLast(succ);
                newPlan.add(succ);
                succ.setPlan(newPlan);
                newPlan.connect(node, succ);
            }
        }
        this.trimBelow(root);
    }

    public void trimBelow(Operator op) throws FrontendException {
        if (this.getSuccessors(op) != null) {
            ArrayList<Operator> succs = new ArrayList<Operator>();
            succs.addAll(this.getSuccessors(op));
            for (Operator succ : succs) {
                this.disconnect(op, succ);
                this.trimBelow(succ);
                this.remove(succ);
            }
        }
    }
}

