/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.evaluation.string;

import java.io.IOException;
import org.apache.pig.EvalFunc;
import org.apache.pig.PigWarning;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class Stuff
extends EvalFunc<String> {
    public String exec(Tuple input) throws IOException {
        int inputSize = input.size();
        if (input == null || inputSize == 0 || input.get(0) == null) {
            this.warn("Null input", (Enum)PigWarning.UDF_WARNING_1);
            return null;
        }
        if (inputSize != 4) {
            throw new IOException("Stuff requires 4 arguments");
        }
        String inString = (String)input.get(0);
        Integer startIndex = null;
        Object inStartIndex = input.get(1);
        if (!(inStartIndex instanceof Number)) {
            this.warn("Specified startIndex is of type " + inStartIndex.getClass().getName() + ", only Numbers are supported", (Enum)PigWarning.UDF_WARNING_1);
            return null;
        }
        startIndex = ((Number)inStartIndex).intValue();
        Integer length = null;
        Object inLength = input.get(2);
        if (!(inLength instanceof Number)) {
            this.warn("Specified length is of type " + inLength.getClass().getName() + ", only Numbers are supported", (Enum)PigWarning.UDF_WARNING_1);
            return null;
        }
        length = ((Number)inLength).intValue();
        String replacementString = (String)input.get(3);
        int strLength = inString.length();
        if (startIndex < 0 || startIndex >= strLength) {
            throw new IOException("Given startIndex " + startIndex + " is out of bounds: [0," + strLength + ")");
        }
        if (length < 0) {
            throw new IOException("The number of characters to delete cannot be negative");
        }
        StringBuffer result = new StringBuffer();
        int upperBound = startIndex + length > strLength ? strLength : startIndex + length;
        int i = 0;
        while (i < strLength) {
            if (i >= startIndex && i < upperBound) {
                if (replacementString != null) {
                    result.append(replacementString);
                }
                i += length.intValue();
                continue;
            }
            result.append(inString.charAt(i));
            ++i;
        }
        return result.toString();
    }

    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 55));
    }
}

