/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.server;

import java.io.IOException;
import java.util.Objects;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.server.AvaticaHandler;
import org.apache.phoenix.shaded.javax.servlet.ServletException;
import org.apache.phoenix.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.phoenix.shaded.javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingAvaticaHandler
implements AvaticaHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DelegatingAvaticaHandler.class);
    private final Handler handler;

    public DelegatingAvaticaHandler(Handler handler) {
        this.handler = Objects.requireNonNull(handler);
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.handler.handle(target, baseRequest, request, response);
    }

    @Override
    public void setServer(Server server) {
        this.handler.setServer(server);
    }

    @Override
    public Server getServer() {
        return this.handler.getServer();
    }

    @Override
    public void destroy() {
        this.handler.destroy();
    }

    @Override
    public void start() throws Exception {
        this.handler.start();
    }

    @Override
    public void stop() throws Exception {
        this.handler.stop();
    }

    @Override
    public boolean isRunning() {
        return this.handler.isRunning();
    }

    @Override
    public boolean isStarted() {
        return this.handler.isStarted();
    }

    @Override
    public boolean isStarting() {
        return this.handler.isStarting();
    }

    @Override
    public boolean isStopping() {
        return this.handler.isStopping();
    }

    @Override
    public boolean isStopped() {
        return this.handler.isStopped();
    }

    @Override
    public boolean isFailed() {
        return this.handler.isFailed();
    }

    @Override
    public void addLifeCycleListener(LifeCycle.Listener listener) {
        this.handler.addLifeCycleListener(listener);
    }

    @Override
    public void removeLifeCycleListener(LifeCycle.Listener listener) {
        this.handler.removeLifeCycleListener(listener);
    }

    @Override
    public void setServerRpcMetadata(Service.RpcMetadataResponse metadata) {
        LOG.warn("Setting RpcMetadata is not implemented for DelegatingAvaticaHandler");
    }
}

