/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.distributed;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.tephra.TxConstants;
import org.apache.tephra.distributed.AbstractClientProvider;
import org.apache.tephra.distributed.CloseableThriftClient;
import org.apache.tephra.distributed.ElasticPool;
import org.apache.tephra.distributed.TransactionServiceThriftClient;
import org.apache.thrift.TException;
import org.apache.twill.discovery.DiscoveryServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledClientProvider
extends AbstractClientProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PooledClientProvider.class);
    private volatile TxClientPool clients;
    private int maxClients;
    private long obtainClientTimeoutMs;

    public PooledClientProvider(Configuration conf, DiscoveryServiceClient discoveryServiceClient) {
        super(conf, discoveryServiceClient);
    }

    private void initializePool() throws TException {
        super.initialize();
        this.maxClients = this.configuration.getInt("data.tx.client.count", 50);
        if (this.maxClients < 1) {
            LOG.warn("Configuration of {} is invalid: Value is {} but must be at least 1. Using 1 as a fallback.", (Object)"data.tx.client.count", (Object)this.maxClients);
            this.maxClients = 1;
        }
        this.obtainClientTimeoutMs = this.configuration.getLong("data.tx.client.obtain.timeout", TxConstants.Service.DEFAULT_DATA_TX_CLIENT_OBTAIN_TIMEOUT_MS);
        if (this.obtainClientTimeoutMs < 0L) {
            LOG.warn("Configuration of {} is invalid: Value is {} but must be at least 0. Using 0 as a fallback.", (Object)"data.tx.client.count", (Object)this.obtainClientTimeoutMs);
            this.obtainClientTimeoutMs = 0L;
        }
        this.clients = new TxClientPool(this.maxClients);
    }

    @Override
    public CloseableThriftClient getCloseableClient() throws TException, TimeoutException, InterruptedException {
        TransactionServiceThriftClient client = (TransactionServiceThriftClient)this.getClientPool().obtain(this.obtainClientTimeoutMs, TimeUnit.MILLISECONDS);
        return new CloseableThriftClient(this, client);
    }

    @Override
    public void returnClient(TransactionServiceThriftClient client) {
        this.getClientPool().release(client);
    }

    public String toString() {
        return String.format("Elastic pool of size %d with timeout %d ms", this.maxClients, this.obtainClientTimeoutMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TxClientPool getClientPool() {
        if (this.clients != null) {
            return this.clients;
        }
        PooledClientProvider pooledClientProvider = this;
        synchronized (pooledClientProvider) {
            if (this.clients == null) {
                try {
                    this.initializePool();
                }
                catch (TException e) {
                    throw new RuntimeException("Failed to initialize transaction client provider: " + this, e);
                }
            }
        }
        return this.clients;
    }

    class TxClientPool
    extends ElasticPool<TransactionServiceThriftClient, TException> {
        TxClientPool(int sizeLimit) {
            super(sizeLimit);
        }

        @Override
        protected TransactionServiceThriftClient create() throws TException {
            return PooledClientProvider.this.newClient();
        }

        @Override
        protected boolean recycle(TransactionServiceThriftClient client) {
            if (!client.isValid()) {
                client.close();
                return false;
            }
            return true;
        }
    }
}

