/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.phoenix.util.ByteUtil;

public class BitSet {
    public static final int BITS_PER_LONG = 64;
    public static final int BITS_PER_INT = 32;
    public static final int BITS_PER_SHORT = 16;
    public static final int BITS_PER_BYTE = 8;
    private final long[] bits;

    public static int getByteSize(int capacity) {
        if (capacity <= 8) {
            return 1;
        }
        if (capacity <= 16) {
            return 2;
        }
        if (capacity <= 32) {
            return 4;
        }
        if (capacity <= 64) {
            return 8;
        }
        int nLongs = (capacity - 1) / 64 + 1;
        return nLongs * 8;
    }

    public static BitSet read(DataInput input, int capacity) throws IOException {
        if (capacity <= 8) {
            return BitSet.fromPrimitive(input.readByte());
        }
        if (capacity <= 16) {
            return BitSet.fromPrimitive(input.readShort());
        }
        if (capacity <= 32) {
            return BitSet.fromPrimitive(input.readInt());
        }
        if (capacity <= 64) {
            return BitSet.fromPrimitive(input.readLong());
        }
        int nLongs = (capacity - 1) / 64 + 1;
        return BitSet.fromArray(ByteUtil.readFixedLengthLongArray(input, nLongs));
    }

    public static void write(DataOutput output, BitSet bitSet, int capacity) throws IOException {
        if (capacity <= 8) {
            output.writeByte((byte)bitSet.bits[0]);
        } else if (capacity <= 16) {
            output.writeShort((short)bitSet.bits[0]);
        } else if (capacity <= 32) {
            output.writeInt((int)bitSet.bits[0]);
        } else if (capacity <= 64) {
            output.writeLong(bitSet.bits[0]);
        } else {
            ByteUtil.writeFixedLengthLongArray(output, bitSet.bits);
        }
    }

    public static BitSet fromPrimitive(byte bits) {
        return new BitSet(new long[]{bits});
    }

    public static BitSet fromPrimitive(short bits) {
        return new BitSet(new long[]{bits});
    }

    public static BitSet fromPrimitive(int bits) {
        return new BitSet(new long[]{bits});
    }

    public static BitSet fromPrimitive(long bits) {
        return new BitSet(new long[]{bits});
    }

    public static BitSet fromArray(long[] bits) {
        return new BitSet(bits);
    }

    public static BitSet withCapacity(int maxBits) {
        int size = Math.max(1, (maxBits + 64 - 1) / 64);
        return new BitSet(new long[size]);
    }

    public BitSet(long[] bits) {
        this.bits = bits;
    }

    public boolean get(int nBit) {
        int lIndex = nBit / 64;
        int bIndex = nBit % 64;
        return (this.bits[lIndex] & 1L << bIndex) != 0L;
    }

    public void set(int nBit) {
        int lIndex = nBit / 64;
        int bIndex = nBit % 64;
        int n = lIndex;
        this.bits[n] = this.bits[n] | 1L << bIndex;
    }
}

