/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PUnsignedSmallint;
import org.apache.phoenix.schema.types.PhoenixArray;

public class PUnsignedSmallintArray
extends PArrayDataType<short[]> {
    public static final PUnsignedSmallintArray INSTANCE = new PUnsignedSmallintArray();

    private PUnsignedSmallintArray() {
        super("UNSIGNED_SMALLINT ARRAY", 3000 + PUnsignedSmallint.INSTANCE.getSqlType(), PhoenixArray.class, null, 44);
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return this.compareTo(lhs, rhs);
    }

    @Override
    public Integer getByteSize() {
        return null;
    }

    @Override
    public byte[] toBytes(Object object) {
        return this.toBytes(object, SortOrder.ASC);
    }

    @Override
    public byte[] toBytes(Object object, SortOrder sortOrder) {
        return this.toBytes(object, PUnsignedSmallint.INSTANCE, sortOrder);
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        return this.toObject(bytes, offset, length, PUnsignedSmallint.INSTANCE, sortOrder, maxLength, scale, PUnsignedSmallint.INSTANCE);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return this.isCoercibleTo(targetType, this);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        short[] shortArr;
        if (value == null) {
            return true;
        }
        PhoenixArray.PrimitiveShortPhoenixArray pArr = (PhoenixArray.PrimitiveShortPhoenixArray)value;
        short[] sArray = shortArr = (short[])pArr.array;
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            Short i2 = sArray[i];
            if (super.isCoercibleTo((PDataType)PUnsignedSmallint.INSTANCE, i2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return this.getSampleValue(PUnsignedSmallint.INSTANCE, arrayLength, maxLength);
    }
}

