/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.sql.SQLException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.schema.PTable;

public class TableAlreadyExistsException
extends SQLException {
    private static final long serialVersionUID = 1L;
    private static SQLExceptionCode code = SQLExceptionCode.TABLE_ALREADY_EXIST;
    private final String schemaName;
    private final String tableName;
    private final PTable table;

    public TableAlreadyExistsException(String schemaName, String tableName) {
        this(schemaName, tableName, null, null);
    }

    public TableAlreadyExistsException(String schemaName, String tableName, String msg) {
        this(schemaName, tableName, msg, null);
    }

    public TableAlreadyExistsException(String schemaName, String tableName, PTable table) {
        this(schemaName, tableName, null, table);
    }

    public TableAlreadyExistsException(String schemaName, String tableName, String msg, PTable table) {
        super(new SQLExceptionInfo.Builder(code).setSchemaName(schemaName).setTableName(tableName).setMessage(msg).build().toString(), code.getSQLState(), code.getErrorCode());
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.table = table;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public PTable getTable() {
        return this.table;
    }
}

