/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import java.util.List;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.FloorDateExpression;
import org.apache.phoenix.expression.function.FloorDecimalExpression;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PTimestamp;

public class FloorParseNode
extends FunctionParseNode {
    FloorParseNode(String name, List<ParseNode> children, FunctionParseNode.BuiltInFunctionInfo info) {
        super(name, children, info);
    }

    @Override
    public Expression create(List<Expression> children, StatementContext context) throws SQLException {
        return FloorParseNode.getFloorExpression(children);
    }

    public static Expression getFloorExpression(List<Expression> children) throws SQLException {
        Expression firstChild = children.get(0);
        PDataType firstChildDataType = firstChild.getDataType();
        if (firstChildDataType.isCoercibleTo(PTimestamp.INSTANCE)) {
            return FloorDateExpression.create(children);
        }
        if (firstChildDataType.isCoercibleTo(PDecimal.INSTANCE)) {
            return FloorDecimalExpression.create(children);
        }
        throw TypeMismatchException.newException(firstChildDataType, "1");
    }

    @Override
    public boolean evalToNullIfParamIsNull(StatementContext context, int index) throws SQLException {
        return index == 0;
    }
}

