/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.index;

import java.util.List;
import org.apache.phoenix.mapreduce.util.IndexColumnNames;
import org.apache.phoenix.schema.PTable;

public interface SourceTargetColumnNames {
    public List<String> getSourceColNames();

    public List<String> getUnqualifiedSourceColNames();

    public List<String> getTargetColNames();

    public List<String> getCastedTargetColNames();

    public List<String> getUnqualifiedTargetColNames();

    public List<String> getSourceDynamicCols();

    public List<String> getTargetDynamicCols();

    public List<String> getTargetPkColNames();

    public List<String> getSourcePkColNames();

    public String getQualifiedSourceTableName();

    public String getQualifiedTargetTableName();

    public static class IndexSourceColNames
    extends IndexColumnNames
    implements SourceTargetColumnNames {
        public IndexSourceColNames(PTable pdataTable, PTable pindexTable) {
            super(pdataTable, pindexTable);
        }

        @Override
        public List<String> getSourceColNames() {
            return this.getIndexColNames();
        }

        @Override
        public List<String> getUnqualifiedSourceColNames() {
            return this.getUnqualifiedIndexColNames();
        }

        @Override
        public List<String> getUnqualifiedTargetColNames() {
            return this.getUnqualifiedDataColNames();
        }

        @Override
        public List<String> getTargetColNames() {
            return this.getDataColNames();
        }

        @Override
        public List<String> getSourceDynamicCols() {
            return this.getDynamicIndexCols();
        }

        @Override
        public List<String> getTargetDynamicCols() {
            return this.getDynamicDataCols();
        }

        @Override
        public List<String> getTargetPkColNames() {
            return this.getDataPkColNames();
        }

        @Override
        public List<String> getSourcePkColNames() {
            return this.getIndexPkColNames();
        }

        @Override
        public String getQualifiedSourceTableName() {
            return this.getQualifiedIndexTableName();
        }

        @Override
        public String getQualifiedTargetTableName() {
            return this.getQualifiedDataTableName();
        }

        @Override
        public List<String> getCastedTargetColNames() {
            return this.getCastedColumnNames(this.getDataColNames(), this.indexColSqlTypeNames);
        }
    }

    public static class DataSourceColNames
    extends IndexColumnNames
    implements SourceTargetColumnNames {
        public DataSourceColNames(PTable pdataTable, PTable pindexTable) {
            super(pdataTable, pindexTable);
        }

        @Override
        public List<String> getSourceColNames() {
            return this.getDataColNames();
        }

        @Override
        public List<String> getUnqualifiedSourceColNames() {
            return this.getUnqualifiedDataColNames();
        }

        @Override
        public List<String> getUnqualifiedTargetColNames() {
            return this.getUnqualifiedIndexColNames();
        }

        @Override
        public List<String> getTargetColNames() {
            return this.getIndexColNames();
        }

        @Override
        public List<String> getSourceDynamicCols() {
            return this.getDynamicDataCols();
        }

        @Override
        public List<String> getTargetDynamicCols() {
            return this.getDynamicIndexCols();
        }

        @Override
        public List<String> getTargetPkColNames() {
            return this.getIndexPkColNames();
        }

        @Override
        public List<String> getSourcePkColNames() {
            return this.getDataPkColNames();
        }

        @Override
        public String getQualifiedSourceTableName() {
            return this.getQualifiedDataTableName();
        }

        @Override
        public String getQualifiedTargetTableName() {
            return this.getQualifiedIndexTableName();
        }

        @Override
        public List<String> getCastedTargetColNames() {
            return this.getCastedColumnNames(this.getIndexColNames(), this.dataColSqlTypeNames);
        }
    }
}

