/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.data;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.hbase.index.covered.data.LocalHBaseState;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.index.PhoenixIndexMetaData;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.types.PVarbinary;

public class CachedLocalTable
implements LocalHBaseState {
    private final Map<ImmutableBytesPtr, List<Cell>> rowKeyPtrToCells;

    private CachedLocalTable(Map<ImmutableBytesPtr, List<Cell>> rowKeyPtrToCells) {
        this.rowKeyPtrToCells = rowKeyPtrToCells;
    }

    @Override
    public List<Cell> getCurrentRowState(Mutation mutation, Collection<? extends ColumnReference> columnReferences, boolean ignoreNewerMutations) throws IOException {
        byte[] rowKey = mutation.getRow();
        List<Cell> cells = this.rowKeyPtrToCells.get((Object)new ImmutableBytesPtr(rowKey));
        if (cells == null || cells.isEmpty()) {
            return cells;
        }
        if (!ignoreNewerMutations) {
            return cells;
        }
        long timestamp = CachedLocalTable.getMutationTimestampWhenAllCellTimestampIsSame(mutation);
        ArrayList<Cell> newCells = new ArrayList<Cell>();
        for (Cell cell : cells) {
            if (cell.getTimestamp() >= timestamp) continue;
            newCells.add(cell);
        }
        return newCells;
    }

    @VisibleForTesting
    public static CachedLocalTable build(Map<ImmutableBytesPtr, List<Cell>> rowKeyPtrToCells) {
        return new CachedLocalTable(rowKeyPtrToCells);
    }

    public static CachedLocalTable build(Collection<? extends Mutation> dataTableMutationsWithSameRowKeyAndTimestamp, PhoenixIndexMetaData indexMetaData, Region region) throws IOException {
        return CachedLocalTable.preScanAllRequiredRows(dataTableMutationsWithSameRowKeyAndTimestamp, indexMetaData, region);
    }

    public static CachedLocalTable preScanAllRequiredRows(Collection<? extends Mutation> dataTableMutationsWithSameRowKeyAndTimestamp, PhoenixIndexMetaData indexMetaData, Region region) throws IOException {
        HashSet<KeyRange> keys = new HashSet<KeyRange>(dataTableMutationsWithSameRowKeyAndTimestamp.size());
        for (Mutation mutation : dataTableMutationsWithSameRowKeyAndTimestamp) {
            if (!indexMetaData.requiresPriorRowState(mutation)) continue;
            keys.add(PVarbinary.INSTANCE.getKeyRange(mutation.getRow()));
        }
        if (keys.isEmpty()) {
            return new CachedLocalTable(Collections.emptyMap());
        }
        List<IndexMaintainer> indexTableMaintainers = indexMetaData.getIndexMaintainers();
        HashSet hashSet = Sets.newHashSet();
        for (IndexMaintainer indexTableMaintainer : indexTableMaintainers) {
            hashSet.addAll(indexTableMaintainer.getAllColumns());
        }
        hashSet.add(new ColumnReference(indexTableMaintainers.get(0).getDataEmptyKeyValueCF(), indexTableMaintainers.get(0).getEmptyKeyValueQualifier()));
        Scan scan = IndexManagementUtil.newLocalStateScan(Collections.singletonList(hashSet));
        ScanRanges scanRanges = ScanRanges.createPointLookup(new ArrayList<KeyRange>(keys));
        scanRanges.initializeScan(scan);
        SkipScanFilter skipScanFilter = scanRanges.getSkipScanFilter();
        if (indexMetaData.getReplayWrite() != null) {
            long timestamp = CachedLocalTable.getMaxTimestamp(dataTableMutationsWithSameRowKeyAndTimestamp);
            scan.setTimeRange(0L, timestamp);
            scan.setFilter((Filter)new SkipScanFilter(skipScanFilter, true));
        } else {
            assert (scan.isRaw());
            scan.setMaxVersions(1);
            scan.setFilter((Filter)skipScanFilter);
        }
        HashMap<ImmutableBytesPtr, List<Cell>> rowKeyPtrToCells = new HashMap<ImmutableBytesPtr, List<Cell>>();
        try (RegionScanner scanner = region.getScanner(scan);){
            boolean more = true;
            while (more) {
                ArrayList cells = new ArrayList();
                more = scanner.next(cells);
                if (cells.isEmpty()) continue;
                Cell cell = (Cell)cells.get(0);
                byte[] rowKey = CellUtil.cloneRow((Cell)cell);
                rowKeyPtrToCells.put(new ImmutableBytesPtr(rowKey), cells);
            }
        }
        return new CachedLocalTable(rowKeyPtrToCells);
    }

    private static long getMaxTimestamp(Collection<? extends Mutation> dataTableMutationsWithSameRowKeyAndTimestamp) {
        long maxTimestamp = Long.MIN_VALUE;
        for (Mutation mutation : dataTableMutationsWithSameRowKeyAndTimestamp) {
            long timestamp = CachedLocalTable.getMutationTimestampWhenAllCellTimestampIsSame(mutation);
            if (timestamp <= maxTimestamp) continue;
            maxTimestamp = timestamp;
        }
        return maxTimestamp;
    }

    private static long getMutationTimestampWhenAllCellTimestampIsSame(Mutation mutation) {
        return ((Cell)((List)mutation.getFamilyCellMap().values().iterator().next()).get(0)).getTimestamp();
    }
}

