/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.io.DataInput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ByteBasedRegexpSubstrFunction;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.PrefixFunction;
import org.apache.phoenix.expression.function.StringBasedRegexpSubstrFunction;
import org.apache.phoenix.expression.util.regex.AbstractBasePattern;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.RegexpSubstrParseNode;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PVarchar;

@FunctionParseNode.BuiltInFunction(name="REGEXP_SUBSTR", nodeClass=RegexpSubstrParseNode.class, args={@FunctionParseNode.Argument(allowedTypes={PVarchar.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class}), @FunctionParseNode.Argument(allowedTypes={PLong.class}, defaultValue="1")}, classType=FunctionParseNode.FunctionClassType.ABSTRACT, derivedFunctions={ByteBasedRegexpSubstrFunction.class, StringBasedRegexpSubstrFunction.class})
public abstract class RegexpSubstrFunction
extends PrefixFunction {
    public static final String NAME = "REGEXP_SUBSTR";
    private AbstractBasePattern pattern;
    private Integer offset;
    private Integer maxLength;
    private static final PDataType TYPE = PVarchar.INSTANCE;

    public RegexpSubstrFunction() {
    }

    public RegexpSubstrFunction(List<Expression> children) {
        super(children);
        this.init();
    }

    protected abstract AbstractBasePattern compilePatternSpec(String var1);

    private void init() {
        Expression offsetExpr;
        String patternStr;
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        Expression patternExpr = this.getPatternExpression();
        if (patternExpr.isStateless() && patternExpr.getDeterminism() == Determinism.ALWAYS && patternExpr.evaluate(null, ptr) && (patternStr = (String)patternExpr.getDataType().toObject(ptr, patternExpr.getSortOrder())) != null) {
            this.pattern = this.compilePatternSpec(patternStr);
        }
        if ((offsetExpr = this.getOffsetExpression()).isStateless() && offsetExpr.getDeterminism() == Determinism.ALWAYS && offsetExpr.evaluate(null, ptr)) {
            PDataType type;
            this.offset = (Integer)PInteger.INSTANCE.toObject(ptr, offsetExpr.getDataType(), offsetExpr.getSortOrder());
            if (this.offset != null && (type = this.getSourceStrExpression().getDataType()).isFixedWidth()) {
                if (this.offset >= 0) {
                    Integer maxLength = this.getSourceStrExpression().getMaxLength();
                    this.maxLength = maxLength - this.offset - (this.offset == 0 ? 0 : 1);
                } else {
                    this.maxLength = -this.offset.intValue();
                }
            }
        }
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        int offset;
        AbstractBasePattern pattern = this.pattern;
        if (pattern == null) {
            Expression patternExpr = this.getPatternExpression();
            if (!patternExpr.evaluate(tuple, ptr)) {
                return false;
            }
            if (ptr.getLength() == 0) {
                return true;
            }
            pattern = this.compilePatternSpec((String)patternExpr.getDataType().toObject(ptr, patternExpr.getSortOrder()));
        }
        if (this.offset == null) {
            Expression offsetExpression = this.getOffsetExpression();
            if (!offsetExpression.evaluate(tuple, ptr)) {
                return false;
            }
            if (ptr.getLength() == 0) {
                return true;
            }
            offset = offsetExpression.getDataType().getCodec().decodeInt(ptr, offsetExpression.getSortOrder());
        } else {
            offset = this.offset;
        }
        Expression strExpression = this.getSourceStrExpression();
        if (!strExpression.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.get().length == 0) {
            return true;
        }
        TYPE.coerceBytes(ptr, strExpression.getDataType(), strExpression.getSortOrder(), SortOrder.ASC);
        pattern.substr(ptr, offset -= offset <= 0 ? 0 : 1);
        return true;
    }

    @Override
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @Override
    public FunctionExpression.OrderPreserving preservesOrder() {
        if (this.offset != null && (this.offset == 0 || this.offset == 1)) {
            return FunctionExpression.OrderPreserving.YES_IF_LAST;
        }
        return FunctionExpression.OrderPreserving.NO;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.init();
    }

    @Override
    public int getKeyFormationTraversalIndex() {
        return this.preservesOrder() == FunctionExpression.OrderPreserving.NO ? -1 : 0;
    }

    private Expression getOffsetExpression() {
        return (Expression)this.children.get(2);
    }

    private Expression getPatternExpression() {
        return (Expression)this.children.get(1);
    }

    private Expression getSourceStrExpression() {
        return (Expression)this.children.get(0);
    }

    @Override
    public PDataType getDataType() {
        return TYPE;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

