/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.snapshot;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.tephra.TransactionManager;
import org.apache.tephra.snapshot.BinaryDecoder;
import org.apache.tephra.snapshot.BinaryEncoder;
import org.apache.tephra.snapshot.DefaultSnapshotCodec;

public class SnapshotCodecV2
extends DefaultSnapshotCodec {
    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    protected void encodeInProgress(BinaryEncoder encoder, Map<Long, TransactionManager.InProgressTx> inProgress) throws IOException {
        if (!inProgress.isEmpty()) {
            encoder.writeInt(inProgress.size());
            for (Map.Entry<Long, TransactionManager.InProgressTx> entry : inProgress.entrySet()) {
                encoder.writeLong(entry.getKey());
                encoder.writeLong(entry.getValue().getExpiration());
                encoder.writeLong(entry.getValue().getVisibilityUpperBound());
                encoder.writeInt(entry.getValue().getType().ordinal());
            }
        }
        encoder.writeInt(0);
    }

    @Override
    protected NavigableMap<Long, TransactionManager.InProgressTx> decodeInProgress(BinaryDecoder decoder) throws IOException {
        int size = decoder.readInt();
        TreeMap inProgress = Maps.newTreeMap();
        while (size != 0) {
            for (int remaining = size; remaining > 0; --remaining) {
                TransactionManager.InProgressType txType;
                long txId = decoder.readLong();
                long expiration = decoder.readLong();
                long visibilityUpperBound = decoder.readLong();
                int txTypeIdx = decoder.readInt();
                try {
                    txType = TransactionManager.InProgressType.values()[txTypeIdx];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new IOException("Type enum ordinal value is out of range: " + txTypeIdx);
                }
                inProgress.put(txId, new TransactionManager.InProgressTx(visibilityUpperBound, expiration, txType, new LongArrayList()));
            }
            size = decoder.readInt();
        }
        return inProgress;
    }
}

