/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.ParseNodeVisitor;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.TerminalParseNode;

public class SubqueryParseNode
extends TerminalParseNode {
    private final SelectStatement select;
    private final boolean expectSingleRow;

    SubqueryParseNode(SelectStatement select, boolean expectSingleRow) {
        this.select = select;
        this.expectSingleRow = expectSingleRow;
    }

    public SelectStatement getSelectNode() {
        return this.select;
    }

    public boolean expectSingleRow() {
        return this.expectSingleRow;
    }

    @Override
    public <T> T accept(ParseNodeVisitor<T> visitor) throws SQLException {
        return visitor.visit(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expectSingleRow ? 1231 : 1237);
        result = 31 * result + (this.select == null ? 0 : this.select.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubqueryParseNode other = (SubqueryParseNode)obj;
        if (this.expectSingleRow != other.expectSingleRow) {
            return false;
        }
        return !(this.select == null ? other.select != null : !this.select.equals(other.select));
    }

    @Override
    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        buf.append('(');
        this.select.toSQL(resolver, buf);
        buf.append(')');
    }
}

