/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeVisitor;
import org.apache.phoenix.parse.TerminalParseNode;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PTimestamp;

public class LiteralParseNode
extends TerminalParseNode {
    public static final List<ParseNode> STAR = Collections.singletonList(new LiteralParseNode(1));
    public static final ParseNode NULL = new LiteralParseNode(null);
    public static final ParseNode ZERO = new LiteralParseNode(0);
    public static final ParseNode ONE = new LiteralParseNode(1);
    public static final ParseNode MINUS_ONE = new LiteralParseNode(-1L);
    public static final ParseNode TRUE = new LiteralParseNode(true);
    public static final ParseNode MIN_LONG_AS_BIG_DECIMAL = new LiteralParseNode(BigDecimal.valueOf(Long.MIN_VALUE).abs());
    public static final ParseNode MIN_LONG = new LiteralParseNode(Long.MIN_VALUE);
    private final Object value;
    private final PDataType type;

    public LiteralParseNode(Object value) {
        this.type = PDataType.fromLiteral(value);
        this.value = this.type == null ? null : this.type.toObject(value, this.type);
    }

    public LiteralParseNode(Object value, PDataType type) {
        this.type = type;
        this.value = this.type == null ? null : this.type.toObject(value, this.type);
    }

    public PDataType getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isStateless() {
        return true;
    }

    @Override
    public <T> T accept(ParseNodeVisitor<T> visitor) throws SQLException {
        return visitor.visit(this);
    }

    public byte[] getBytes() {
        return this.type == null ? null : this.type.toBytes(this.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LiteralParseNode other = (LiteralParseNode)obj;
        if (this.value == other.value) {
            return true;
        }
        if (this.type == null) {
            return false;
        }
        return this.type.isComparableTo(other.type) && this.type.compareTo(this.value, other.value, other.type) == 0;
    }

    @Override
    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        if (this.value == null) {
            buf.append(" null ");
        } else if (this.type.isCoercibleTo(PTimestamp.INSTANCE)) {
            buf.append(this.type);
            buf.append(' ');
            buf.append(this.type.toStringLiteral(this.value, null));
        } else {
            buf.append(this.type.toStringLiteral(this.value, null));
        }
    }
}

