/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.phoenix.util.SchemaUtil;

public class HintNode {
    public static final HintNode EMPTY_HINT_NODE = new HintNode();
    public static final char SEPARATOR = ' ';
    public static final String PREFIX = "(";
    public static final String SUFFIX = ")";
    private static final String SPLIT_REGEXP = "\\s+|((?<=\\()|(?=\\())|((?<=\\))|(?=\\)))";
    private final Map<Hint, String> hints;

    public static HintNode create(HintNode hintNode, Hint hint) {
        return HintNode.create(hintNode, hint, "");
    }

    public static HintNode create(HintNode hintNode, Hint hint, String value) {
        HashMap<Hint, String> hints = new HashMap<Hint, String>(hintNode.hints);
        hints.put(hint, value);
        return new HintNode(hints);
    }

    public static HintNode combine(HintNode hintNode, HintNode override) {
        HashMap<Hint, String> hints = new HashMap<Hint, String>(hintNode.hints);
        hints.putAll(override.hints);
        return new HintNode(hints);
    }

    public static HintNode subtract(HintNode hintNode, Hint[] remove) {
        HashMap<Hint, String> hints = new HashMap<Hint, String>(hintNode.hints);
        for (Hint hint : remove) {
            hints.remove((Object)hint);
        }
        return new HintNode(hints);
    }

    private HintNode() {
        this.hints = new HashMap<Hint, String>();
    }

    private HintNode(Map<Hint, String> hints) {
        this.hints = ImmutableMap.copyOf(hints);
    }

    public HintNode(String hint) {
        HashMap<Hint, String> hints = new HashMap<Hint, String>();
        String[] hintWords = hint.split(SPLIT_REGEXP);
        for (int i = 0; i < hintWords.length; ++i) {
            String hintWord = hintWords[i];
            if (hintWord.isEmpty()) continue;
            try {
                String oldValue;
                Hint key = Hint.valueOf(hintWord.toUpperCase());
                String hintValue = "";
                if (i + 1 < hintWords.length && PREFIX.equals(hintWords[i + 1])) {
                    StringBuffer hintValueBuf = new StringBuffer(hint.length());
                    hintValueBuf.append(PREFIX);
                    i += 2;
                    while (i < hintWords.length && !SUFFIX.equals(hintWords[i])) {
                        hintValueBuf.append(SchemaUtil.normalizeIdentifier(hintWords[i++]));
                        hintValueBuf.append(' ');
                    }
                    hintValueBuf.replace(hintValueBuf.length() - 1, hintValueBuf.length(), SUFFIX);
                    hintValue = hintValueBuf.toString();
                }
                if ((oldValue = hints.put(key, hintValue)) == null) continue;
                hints.put(key, oldValue + hintValue);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.hints = ImmutableMap.copyOf(hints);
    }

    public boolean isEmpty() {
        return this.hints.isEmpty();
    }

    public String getHint(Hint hint) {
        return this.hints.get((Object)hint);
    }

    public boolean hasHint(Hint hint) {
        return this.hints.containsKey((Object)hint);
    }

    public Set<Hint> getHints() {
        return this.hints.keySet();
    }

    public String toString() {
        if (this.hints.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder("/*+ ");
        for (Map.Entry<Hint, String> entry : this.hints.entrySet()) {
            buf.append((Object)entry.getKey());
            buf.append(entry.getValue());
            buf.append(' ');
        }
        buf.append("*/ ");
        return buf.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hints == null ? 0 : this.hints.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HintNode other = (HintNode)obj;
        return !(this.hints == null ? other.hints != null : !this.hints.equals(other.hints));
    }

    public static enum Hint {
        RANGE_SCAN,
        SKIP_SCAN,
        NO_CHILD_PARENT_JOIN_OPTIMIZATION,
        NO_INDEX,
        INDEX,
        USE_DATA_OVER_INDEX_TABLE,
        USE_INDEX_OVER_DATA_TABLE,
        NO_CACHE,
        USE_SORT_MERGE_JOIN,
        USE_PERSISTENT_CACHE,
        NO_STAR_JOIN,
        SEEK_TO_COLUMN,
        NO_SEEK_TO_COLUMN,
        SMALL,
        SERIAL,
        FORWARD_SCAN,
        HASH_AGGREGATE;

    }
}

