/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.bulkload.TableRowkeyPair;
import org.apache.phoenix.mapreduce.bulkload.TargetTableRefFunctions;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.Closeables;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatToKeyValueReducer
extends Reducer<TableRowkeyPair, ImmutableBytesWritable, TableRowkeyPair, KeyValue> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(FormatToKeyValueReducer.class);
    protected List<String> tableNames;
    protected List<String> logicalNames;
    protected KeyValueBuilder builder;
    private Map<Integer, Pair<byte[], byte[]>> columnIndexes;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        Properties clientInfos = new Properties();
        for (Map.Entry entry : conf) {
            clientInfos.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        try (PhoenixConnection conn = (PhoenixConnection)QueryUtil.getConnectionOnServer(clientInfos, conf);){
            this.builder = conn.getKeyValueBuilder();
            String tableNamesConf = conf.get("phoenix.mapreduce.import.tablenames");
            String logicalNamesConf = conf.get("phoenix.mapreduce.import.logicalnames");
            this.tableNames = (List)TargetTableRefFunctions.NAMES_FROM_JSON.apply((Object)tableNamesConf);
            this.logicalNames = (List)TargetTableRefFunctions.NAMES_FROM_JSON.apply((Object)logicalNamesConf);
            this.initColumnsMap(conn);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void initColumnsMap(PhoenixConnection conn) throws SQLException {
        TreeMap<byte[], Integer> indexMap = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        this.columnIndexes = new HashMap<Integer, Pair<byte[], byte[]>>();
        int columnIndex = 0;
        for (int index = 0; index < this.logicalNames.size(); ++index) {
            int i;
            PTable table = PhoenixRuntime.getTable(conn, this.logicalNames.get(index));
            if (!table.getImmutableStorageScheme().equals(PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN)) {
                List<PColumnFamily> cfs = table.getColumnFamilies();
                for (i = 0; i < cfs.size(); ++i) {
                    byte[] family = cfs.get(i).getName().getBytes();
                    Pair pair = new Pair((Object)family, (Object)QueryConstants.SINGLE_KEYVALUE_COLUMN_QUALIFIER_BYTES);
                    this.columnIndexes.put(new Integer(columnIndex), (Pair<byte[], byte[]>)pair);
                    ++columnIndex;
                }
            } else {
                List<PColumn> cls = table.getColumns();
                for (i = 0; i < cls.size(); ++i) {
                    byte[] cq;
                    PColumn c = cls.get(i);
                    byte[] family = new byte[]{};
                    if (!SchemaUtil.isPKColumn(c)) {
                        family = c.getFamilyName().getBytes();
                        cq = c.getColumnQualifierBytes();
                    } else {
                        cq = c.getName().getBytes();
                    }
                    byte[] cfn = Bytes.add((byte[])family, (byte[])QueryConstants.NAMESPACE_SEPARATOR_BYTES, (byte[])cq);
                    Pair pair = new Pair((Object)family, (Object)cq);
                    if (indexMap.containsKey(cfn)) continue;
                    indexMap.put(cfn, new Integer(columnIndex));
                    this.columnIndexes.put(new Integer(columnIndex), (Pair<byte[], byte[]>)pair);
                    ++columnIndex;
                }
            }
            byte[] emptyColumnFamily = SchemaUtil.getEmptyColumnFamily(table);
            byte[] emptyKeyValue = (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo(table).getFirst();
            Pair pair = new Pair((Object)emptyColumnFamily, (Object)emptyKeyValue);
            this.columnIndexes.put(new Integer(columnIndex), (Pair<byte[], byte[]>)pair);
            ++columnIndex;
        }
    }

    protected void reduce(TableRowkeyPair key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        TreeSet<KeyValue> map = new TreeSet<KeyValue>((Comparator<KeyValue>)KeyValue.COMPARATOR);
        for (ImmutableBytesWritable aggregatedArray : values) {
            DataInputStream input = new DataInputStream(new ByteArrayInputStream(aggregatedArray.get()));
            while (input.available() != 0) {
                KeyValue kv;
                byte type = input.readByte();
                long timestamp = WritableUtils.readVLong((DataInput)input);
                int index = WritableUtils.readVInt((DataInput)input);
                ImmutableBytesPtr value = QueryConstants.EMPTY_COLUMN_VALUE_BYTES_PTR;
                Pair<byte[], byte[]> pair = this.columnIndexes.get(index);
                ImmutableBytesWritable family = new ImmutableBytesWritable((byte[])pair.getFirst());
                ImmutableBytesWritable cq = new ImmutableBytesWritable((byte[])pair.getSecond());
                int len = WritableUtils.readVInt((DataInput)input);
                if (len > 0) {
                    byte[] array = new byte[len];
                    input.read(array);
                    value = new ImmutableBytesWritable(array);
                }
                KeyValue.Type kvType = KeyValue.Type.codeToType((byte)type);
                switch (kvType) {
                    case Put: {
                        kv = this.builder.buildPut(key.getRowkey(), family, cq, timestamp, value);
                        break;
                    }
                    case DeleteColumn: {
                        kv = this.builder.buildDeleteColumns(key.getRowkey(), family, cq, timestamp);
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported KeyValue type " + kvType);
                    }
                }
                map.add(kv);
            }
            Closeables.closeQuietly(input);
        }
        context.setStatus("Read " + map.getClass());
        int index = 0;
        for (KeyValue kv : map) {
            context.write((Object)key, (Object)kv);
            if (++index % 100 != 0) continue;
            context.setStatus("Wrote " + index);
        }
    }
}

