/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.filter;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;

public class EncodedQualifiersColumnProjectionFilter
extends FilterBase
implements Writable {
    private byte[] emptyCFName;
    private BitSet trackedColumns;
    private PTable.QualifierEncodingScheme encodingScheme;
    private Set<byte[]> conditionOnlyCfs;

    public EncodedQualifiersColumnProjectionFilter() {
    }

    public EncodedQualifiersColumnProjectionFilter(byte[] emptyCFName, BitSet trackedColumns, Set<byte[]> conditionCfs, PTable.QualifierEncodingScheme encodingScheme) {
        Preconditions.checkArgument((encodingScheme != PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS ? 1 : 0) != 0, (Object)"Filter can only be used for encoded qualifiers");
        this.emptyCFName = emptyCFName;
        this.trackedColumns = trackedColumns;
        this.encodingScheme = encodingScheme;
        this.conditionOnlyCfs = conditionCfs;
    }

    public void readFields(DataInput input) throws IOException {
        this.emptyCFName = WritableUtils.readCompressedByteArray((DataInput)input);
        int bitsetLongArraySize = WritableUtils.readVInt((DataInput)input);
        long[] bitsetLongArray = new long[bitsetLongArraySize];
        for (int i = 0; i < bitsetLongArraySize; ++i) {
            bitsetLongArray[i] = WritableUtils.readVLong((DataInput)input);
        }
        this.trackedColumns = BitSet.valueOf(bitsetLongArray);
        this.encodingScheme = PTable.QualifierEncodingScheme.values()[WritableUtils.readVInt((DataInput)input)];
        this.conditionOnlyCfs = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (int conditionOnlyCfsSize = WritableUtils.readVInt((DataInput)input); conditionOnlyCfsSize > 0; --conditionOnlyCfsSize) {
            this.conditionOnlyCfs.add(WritableUtils.readCompressedByteArray((DataInput)input));
        }
    }

    public void write(DataOutput output) throws IOException {
        WritableUtils.writeCompressedByteArray((DataOutput)output, (byte[])this.emptyCFName);
        long[] longArrayOfBitSet = this.trackedColumns.toLongArray();
        WritableUtils.writeVInt((DataOutput)output, (int)longArrayOfBitSet.length);
        Object object = longArrayOfBitSet;
        int n = ((long[])object).length;
        for (int i = 0; i < n; ++i) {
            Long l = object[i];
            WritableUtils.writeVLong((DataOutput)output, (long)l);
        }
        WritableUtils.writeVInt((DataOutput)output, (int)this.encodingScheme.ordinal());
        WritableUtils.writeVInt((DataOutput)output, (int)this.conditionOnlyCfs.size());
        object = this.conditionOnlyCfs.iterator();
        while (object.hasNext()) {
            byte[] f = (byte[])object.next();
            WritableUtils.writeCompressedByteArray((DataOutput)output, (byte[])f);
        }
    }

    public byte[] toByteArray() throws IOException {
        return Writables.getBytes((Writable)this);
    }

    public static EncodedQualifiersColumnProjectionFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        try {
            return (EncodedQualifiersColumnProjectionFilter)Writables.getWritable((byte[])pbBytes, (Writable)new EncodedQualifiersColumnProjectionFilter());
        }
        catch (IOException e) {
            throw new DeserializationException((Throwable)e);
        }
    }

    public void filterRowCells(List<Cell> kvs) throws IOException {
        if (kvs.isEmpty()) {
            return;
        }
        Cell firstKV = kvs.get(0);
        Iterables.removeIf(kvs, (Predicate)new Predicate<Cell>(){

            public boolean apply(Cell kv) {
                int qualifier = EncodedQualifiersColumnProjectionFilter.this.encodingScheme.decode(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength());
                return !EncodedQualifiersColumnProjectionFilter.this.trackedColumns.get(qualifier);
            }
        });
        if (kvs.isEmpty()) {
            kvs.add((Cell)new KeyValue(firstKV.getRowArray(), firstKV.getRowOffset(), (int)firstKV.getRowLength(), this.emptyCFName, 0, this.emptyCFName.length, QueryConstants.ENCODED_EMPTY_COLUMN_BYTES, 0, QueryConstants.ENCODED_EMPTY_COLUMN_BYTES.length, Long.MAX_VALUE, KeyValue.Type.Maximum, null, 0, 0));
        }
    }

    public boolean hasFilterRow() {
        return true;
    }

    public boolean isFamilyEssential(byte[] name) {
        return this.conditionOnlyCfs.isEmpty() || this.conditionOnlyCfs.contains(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append(String.format("EmptyCFName: %s, ", Bytes.toStringBinary((byte[])this.emptyCFName)));
        sb.append(String.format("EncodingScheme: %s, ", this.encodingScheme));
        sb.append(String.format("TrackedColumns: %s, ", this.trackedColumns));
        sb.append("ConditionOnlyCfs: ");
        for (byte[] conditionOnlyCf : this.conditionOnlyCfs) {
            sb.append(String.format("%s, ", Bytes.toStringBinary((byte[])conditionOnlyCf)));
        }
        return sb.toString();
    }

    public Filter.ReturnCode filterKeyValue(Cell ignored) throws IOException {
        return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
    }

    public void addTrackedColumn(int qualifier) {
        this.trackedColumns.set(qualifier);
    }

    static interface ColumnTracker {
    }
}

