/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.rewrite;

import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.RowValueConstructorExpression;
import org.apache.phoenix.schema.SortOrder;

public class RowValueConstructorExpressionRewriter {
    static RowValueConstructorExpressionRewriter singleton = null;

    public static RowValueConstructorExpressionRewriter getSingleton() {
        if (singleton == null) {
            singleton = new RowValueConstructorExpressionRewriter();
        }
        return singleton;
    }

    public RowValueConstructorExpression rewriteAllChildrenAsc(RowValueConstructorExpression rvcExpression) throws SQLException {
        ArrayList<Expression> replacementChildren = new ArrayList<Expression>(rvcExpression.getChildren().size());
        for (int i = 0; i < rvcExpression.getChildren().size(); ++i) {
            Expression child = rvcExpression.getChildren().get(i);
            if (child.getSortOrder() == SortOrder.DESC) {
                child = CoerceExpression.create(child, child.getDataType(), SortOrder.ASC, null);
            }
            replacementChildren.add(child);
        }
        return rvcExpression.clone(replacementChildren);
    }
}

