/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.io.DataInput;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PLong;

@FunctionParseNode.BuiltInFunction(name="RAND", args={@FunctionParseNode.Argument(allowedTypes={PLong.class}, defaultValue="null", isConstant=true)})
public class RandomFunction
extends ScalarFunction {
    public static final String NAME = "RAND";
    private Random random;
    private boolean hasSeed;
    private Double current;

    public RandomFunction() {
    }

    public RandomFunction(List<Expression> children) {
        super(children);
        this.init();
    }

    private void init() {
        Number seed = (Number)((LiteralExpression)this.children.get(0)).getValue();
        this.random = seed == null ? new Random() : new Random(seed.longValue());
        this.hasSeed = seed != null;
        this.current = null;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.init();
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (this.current == null) {
            this.current = this.random.nextDouble();
        }
        ptr.set(PDouble.INSTANCE.toBytes(this.current));
        return true;
    }

    @Override
    public void reset() {
        super.reset();
        this.current = null;
    }

    @Override
    public PDataType<?> getDataType() {
        return PDouble.INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Determinism getDeterminism() {
        return this.hasSeed ? Determinism.PER_ROW : Determinism.PER_INVOCATION;
    }

    @Override
    public boolean isCloneExpression() {
        return RandomFunction.isCloneExpressionByDeterminism(this);
    }

    @Override
    public boolean isStateless() {
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        return this.hasSeed ? hashCode : hashCode + this.random.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && (this.hasSeed || this.random.equals(((RandomFunction)obj).random));
    }

    @Override
    public final String toString() {
        StringBuilder buf = new StringBuilder(this.getName() + "(");
        if (!this.hasSeed) {
            return buf.append(")").toString();
        }
        for (int i = 0; i < this.children.size() - 1; ++i) {
            buf.append(this.children.get(i) + ", ");
        }
        buf.append(this.children.get(this.children.size() - 1) + ")");
        return buf.toString();
    }
}

