/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.aggregator.CountAggregator;
import org.apache.phoenix.expression.aggregator.LongSumAggregator;
import org.apache.phoenix.expression.function.SingleAggregateFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.SchemaUtil;

@FunctionParseNode.BuiltInFunction(name="COUNT", args={@FunctionParseNode.Argument})
public class CountAggregateFunction
extends SingleAggregateFunction {
    public static final String NAME = "COUNT";
    public static final List<Expression> STAR = Arrays.asList(LiteralExpression.newConstant((Object)1, Determinism.ALWAYS));
    public static final String NORMALIZED_NAME = SchemaUtil.normalizeIdentifier("COUNT");

    public CountAggregateFunction() {
    }

    public CountAggregateFunction(List<Expression> childExpressions) {
        super(childExpressions);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CountAggregateFunction other = (CountAggregateFunction)obj;
        return this.isConstantExpression() && other.isConstantExpression() || this.children.equals(other.getChildren());
    }

    @Override
    public int hashCode() {
        return this.isConstantExpression() ? 0 : super.hashCode();
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public PDataType getDataType() {
        return PLong.INSTANCE;
    }

    @Override
    public LongSumAggregator newClientAggregator() {
        return new LongSumAggregator(){

            @Override
            public boolean isNullable() {
                return false;
            }
        };
    }

    @Override
    public Aggregator newServerAggregator(Configuration conf) {
        return new CountAggregator();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Aggregator newServerAggregator(Configuration config, ImmutableBytesWritable ptr) {
        LongSumAggregator sumAgg = this.newClientAggregator();
        sumAgg.aggregate(null, ptr);
        return new CountAggregator(sumAgg);
    }
}

