/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.aggregator;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.ColumnExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.aggregator.DistinctValueWithCountClientAggregator;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;

public class PercentileDiscClientAggregator
extends DistinctValueWithCountClientAggregator {
    private final List<Expression> exps;
    ColumnExpression columnExp = null;

    public PercentileDiscClientAggregator(List<Expression> exps, SortOrder sortOrder) {
        super(sortOrder);
        this.exps = exps;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        this.buffer = null;
        if (this.cachedResult == null) {
            this.columnExp = (ColumnExpression)this.exps.get(0);
            LiteralExpression isAscendingExpression = (LiteralExpression)this.exps.get(1);
            boolean isAscending = (Boolean)isAscendingExpression.getValue();
            LiteralExpression percentileExp = (LiteralExpression)this.exps.get(2);
            float p = ((Number)percentileExp.getValue()).floatValue();
            Map<Object, Integer> sorted = this.getSortedValueVsCount(isAscending, this.columnExp.getDataType());
            int currValue = 0;
            Object result = null;
            for (Map.Entry<Object, Integer> entry : sorted.entrySet()) {
                result = entry.getKey();
                Integer value = entry.getValue();
                float cum_dist = (float)(currValue += value.intValue()) / (float)this.totalCount;
                if (!(cum_dist >= p)) continue;
                break;
            }
            this.cachedResult = result;
        }
        if (this.buffer == null) {
            this.buffer = new byte[this.columnExp.getDataType().getByteSize().intValue()];
        }
        System.arraycopy(this.columnExp.getDataType().toBytes(this.cachedResult), 0, this.buffer, 0, this.buffer.length);
        ptr.set(this.buffer);
        return true;
    }

    @Override
    protected int getBufferLength() {
        return PDecimal.INSTANCE.getByteSize();
    }

    @Override
    protected PDataType getResultDataType() {
        return this.columnExp.getDataType();
    }
}

