/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.aggregator;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.aggregator.BaseAggregator;
import org.apache.phoenix.expression.aggregator.DistinctValueWithCountClientAggregator;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.util.ByteUtil;
import org.iq80.snappy.Snappy;

public class DistinctValueWithCountServerAggregator
extends BaseAggregator {
    public static final int DEFAULT_ESTIMATED_DISTINCT_VALUES = 10000;
    public static final byte[] COMPRESS_MARKER = new byte[]{1};
    private static final int COPY_THRESHOLD = 10;
    private static final int FIXED_COPY_THRESHOLD = 48;
    private int compressThreshold;
    private int heapSize = 0;
    private byte[] buffer = null;
    protected Map<ImmutableBytesPtr, Integer> valueVsCount = new HashMap<ImmutableBytesPtr, Integer>();

    public DistinctValueWithCountServerAggregator(Configuration conf) {
        super(SortOrder.getDefault());
        this.compressThreshold = conf.getInt("phoenix.distinct.value.compress.threshold", 0x100000);
    }

    public DistinctValueWithCountServerAggregator(Configuration conf, DistinctValueWithCountClientAggregator clientAgg) {
        this(conf);
        this.valueVsCount = clientAgg.valueVsCount;
    }

    @Override
    public void aggregate(Tuple tuple, ImmutableBytesWritable ptr) {
        ImmutableBytesPtr key = ptr.get().length > 48 && ptr.get().length > ptr.getLength() * 10 ? new ImmutableBytesPtr(ptr.copyBytes()) : new ImmutableBytesPtr(ptr);
        Integer count = this.valueVsCount.get((Object)key);
        if (count == null) {
            this.valueVsCount.put(key, 1);
            this.heapSize += 48 + key.getLength() + 24;
        } else {
            count = count + 1;
            this.valueVsCount.put(key, count);
        }
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        int serializationSize = this.countMapSerializationSize();
        this.buffer = new byte[serializationSize];
        int offset = 1;
        offset += ByteUtil.vintToBytes(this.buffer, offset, this.valueVsCount.size());
        for (Map.Entry<ImmutableBytesPtr, Integer> entry : this.valueVsCount.entrySet()) {
            ImmutableBytesPtr key = entry.getKey();
            offset += ByteUtil.vintToBytes(this.buffer, offset, key.getLength());
            System.arraycopy(key.get(), key.getOffset(), this.buffer, offset, key.getLength());
            offset += key.getLength();
            offset += ByteUtil.vintToBytes(this.buffer, offset, entry.getValue().intValue());
        }
        if (serializationSize > this.compressThreshold) {
            byte[] compressed = new byte[COMPRESS_MARKER.length + Snappy.maxCompressedLength(this.buffer.length)];
            System.arraycopy(COMPRESS_MARKER, 0, compressed, 0, COMPRESS_MARKER.length);
            int compressedLen = Snappy.compress(this.buffer, 1, this.buffer.length - 1, compressed, COMPRESS_MARKER.length);
            ptr.set(compressed, 0, compressedLen + 1);
            return true;
        }
        ptr.set(this.buffer, 0, offset);
        return true;
    }

    private int countMapSerializationSize() {
        int size = 4;
        for (ImmutableBytesPtr key : this.valueVsCount.keySet()) {
            size += key.getLength() + 4 + 4;
        }
        return size;
    }

    private int countMapHeapSize() {
        return this.heapSize;
    }

    @Override
    public final PDataType getDataType() {
        return PVarbinary.INSTANCE;
    }

    @Override
    public void reset() {
        this.valueVsCount = new HashMap<ImmutableBytesPtr, Integer>();
        this.heapSize = 0;
        this.buffer = null;
        super.reset();
    }

    public String toString() {
        return "DISTINCT VALUE vs COUNT";
    }

    @Override
    public int getSize() {
        return super.getSize() + 24 + this.countMapHeapSize();
    }

    @Override
    public boolean trackSize() {
        return true;
    }
}

