/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.ArithmeticExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.SubtractExpression;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.util.DateUtil;

public class TimestampSubtractExpression
extends SubtractExpression {
    public TimestampSubtractExpression() {
    }

    public TimestampSubtractExpression(List<Expression> children) {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        BigDecimal finalResult = BigDecimal.ZERO;
        for (int i = 0; i < this.children.size(); ++i) {
            if (!((Expression)this.children.get(i)).evaluate(tuple, ptr)) {
                return false;
            }
            if (ptr.getLength() == 0) {
                return true;
            }
            PDataType type = ((Expression)this.children.get(i)).getDataType();
            SortOrder sortOrder = ((Expression)this.children.get(i)).getSortOrder();
            BigDecimal value = type == PTimestamp.INSTANCE || type == PUnsignedTimestamp.INSTANCE ? (BigDecimal)PDecimal.INSTANCE.toObject(ptr, type, sortOrder) : (type.isCoercibleTo(PDecimal.INSTANCE) ? ((BigDecimal)PDecimal.INSTANCE.toObject(ptr, type, sortOrder)).multiply(BD_MILLIS_IN_DAY).setScale(6, RoundingMode.HALF_UP) : (type.isCoercibleTo(PDouble.INSTANCE) ? BigDecimal.valueOf(type.getCodec().decodeDouble(ptr, sortOrder)).multiply(BD_MILLIS_IN_DAY).setScale(6, RoundingMode.HALF_UP) : BigDecimal.valueOf(type.getCodec().decodeLong(ptr, sortOrder))));
            finalResult = i == 0 ? value : finalResult.subtract(value);
        }
        Timestamp ts = DateUtil.getTimestamp(finalResult);
        byte[] resultPtr = new byte[this.getDataType().getByteSize().intValue()];
        PTimestamp.INSTANCE.toBytes(ts, resultPtr, 0);
        ptr.set(resultPtr);
        return true;
    }

    @Override
    public final PDataType getDataType() {
        return PTimestamp.INSTANCE;
    }

    @Override
    public ArithmeticExpression clone(List<Expression> children) {
        return new TimestampSubtractExpression(children);
    }
}

