/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.ArithmeticExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;

public class ModulusExpression
extends ArithmeticExpression {
    public ModulusExpression() {
    }

    public ModulusExpression(List<Expression> children) {
        super(children);
    }

    private Expression getDividendExpression() {
        return (Expression)this.children.get(0);
    }

    private Expression getDivisorExpression() {
        return (Expression)this.children.get(1);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression dividendExpression = this.getDividendExpression();
        if (!dividendExpression.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        long dividend = dividendExpression.getDataType().getCodec().decodeLong(ptr, dividendExpression.getSortOrder());
        Expression divisorExpression = this.getDivisorExpression();
        if (!divisorExpression.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        long divisor = divisorExpression.getDataType().getCodec().decodeLong(ptr, divisorExpression.getSortOrder());
        long remainder = dividend % divisor;
        byte[] resultPtr = new byte[PLong.INSTANCE.getByteSize().intValue()];
        this.getDataType().getCodec().encodeLong(remainder, resultPtr, 0);
        ptr.set(resultPtr);
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PLong.INSTANCE;
    }

    @Override
    protected String getOperatorString() {
        return " % ";
    }

    @Override
    public final <T> T accept(ExpressionVisitor<T> visitor) {
        List<T> l = this.acceptChildren(visitor, visitor.visitEnter(this));
        T t = visitor.visitLeave(this, l);
        if (t == null) {
            t = visitor.defaultReturn(this, l);
        }
        return t;
    }

    @Override
    public ArithmeticExpression clone(List<Expression> children) {
        return new ModulusExpression(children);
    }
}

