/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.BaseCompoundExpression;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.util.regex.AbstractBasePattern;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.parse.LikeParseNode;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LikeExpression
extends BaseCompoundExpression {
    private static final Logger LOGGER = LoggerFactory.getLogger(LikeExpression.class);
    private static final String ZERO_OR_MORE = "\\E.*\\Q";
    private static final String ANY_ONE = "\\E.\\Q";
    private LikeParseNode.LikeType likeType;
    private static final int LIKE_TYPE_INDEX = 2;
    private static final LiteralExpression[] LIKE_TYPE_LITERAL = new LiteralExpression[LikeParseNode.LikeType.values().length];
    private AbstractBasePattern pattern;

    public static String unescapeLike(String s) {
        return StringUtil.replace(s, StringUtil.LIKE_ESCAPE_SEQS, StringUtil.LIKE_UNESCAPED_SEQS);
    }

    public static String getStartsWithPrefix(String s) {
        int i = LikeExpression.indexOfWildcard(s);
        return i == -1 ? s : s.substring(0, i);
    }

    public static boolean hasWildcards(String s) {
        return LikeExpression.indexOfWildcard(s) != -1;
    }

    public static String wildCardToLike(String s) {
        s = StringUtil.escapeLike(s);
        StringBuilder buf = new StringBuilder();
        int i = 0;
        int j = 0;
        while (true) {
            int pctPos = s.indexOf(42, i);
            int underPos = s.indexOf(63, i);
            if (pctPos == -1 && underPos == -1) {
                return i == 0 ? s : buf.append(s.substring(i)).toString();
            }
            i = pctPos;
            if (underPos != -1 && (i == -1 || underPos < i)) {
                i = underPos;
            }
            if (i > 0 && s.charAt(i - 1) == '\\') {
                buf.append(s.substring(j, i - 1));
                buf.append(s.charAt(i));
            } else {
                buf.append(s.substring(j, i));
                buf.append(s.charAt(i) == '*' ? (char)'%' : '_');
            }
            j = ++i;
        }
    }

    public static int indexOfWildcard(String s) {
        if (s == null) {
            return -1;
        }
        int i = 0;
        while (true) {
            int pctPos = s.indexOf(37, i);
            int underPos = s.indexOf(95, i);
            if (pctPos == -1 && underPos == -1) {
                return -1;
            }
            i = pctPos;
            if (underPos != -1 && (i == -1 || underPos < i)) {
                i = underPos;
            }
            if (i <= 0 || s.charAt(i - 1) != '\\') break;
            ++i;
        }
        return i;
    }

    public static String toPattern(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        sb.append("\\Q");
        boolean wasSlash = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (wasSlash) {
                sb.append(c);
                wasSlash = false;
                continue;
            }
            if (c == '_') {
                sb.append(ANY_ONE);
                continue;
            }
            if (c == '%') {
                sb.append(ZERO_OR_MORE);
                continue;
            }
            if (c == '\\') {
                wasSlash = true;
                continue;
            }
            sb.append(c);
        }
        sb.append("\\E");
        return sb.toString();
    }

    public LikeExpression() {
    }

    protected static List<Expression> addLikeTypeChild(List<Expression> children, LikeParseNode.LikeType likeType) {
        ArrayList newChildren = Lists.newArrayListWithExpectedSize((int)(children.size() + 1));
        newChildren.addAll(children);
        newChildren.add(LIKE_TYPE_LITERAL[likeType.ordinal()]);
        return newChildren;
    }

    public LikeExpression(List<Expression> children) {
        super(children);
        this.init();
    }

    public LikeParseNode.LikeType getLikeType() {
        return this.likeType;
    }

    public boolean startsWithWildcard() {
        return this.pattern != null && this.pattern.pattern().startsWith("\\Q\\E");
    }

    private void init() {
        List<Expression> children = this.getChildren();
        if (children.size() <= 2) {
            this.likeType = LikeParseNode.LikeType.CASE_SENSITIVE;
        } else {
            LiteralExpression likeTypeExpression = (LiteralExpression)children.get(2);
            this.likeType = LikeParseNode.LikeType.valueOf((String)likeTypeExpression.getValue());
        }
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        Expression e = this.getPatternExpression();
        if (e.isStateless() && e.getDeterminism() == Determinism.ALWAYS && e.evaluate(null, ptr)) {
            String value = (String)PVarchar.INSTANCE.toObject(ptr, e.getDataType(), e.getSortOrder());
            this.pattern = this.compilePattern(value);
        }
    }

    protected abstract AbstractBasePattern compilePatternSpec(String var1);

    protected AbstractBasePattern compilePattern(String value) {
        if (this.likeType == LikeParseNode.LikeType.CASE_SENSITIVE) {
            return this.compilePatternSpec(LikeExpression.toPattern(value));
        }
        return this.compilePatternSpec("(?i)" + LikeExpression.toPattern(value));
    }

    private Expression getStrExpression() {
        return (Expression)this.children.get(0);
    }

    private Expression getPatternExpression() {
        return (Expression)this.children.get(1);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        AbstractBasePattern pattern = this.pattern;
        if (pattern == null) {
            if (!this.getPatternExpression().evaluate(tuple, ptr)) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("LIKE is FALSE: pattern is null");
                }
                return false;
            }
            String value = (String)PVarchar.INSTANCE.toObject(ptr, this.getPatternExpression().getSortOrder());
            pattern = this.compilePattern(value);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("LIKE pattern is expression: " + pattern.pattern());
            }
        }
        Expression strExpression = this.getStrExpression();
        SortOrder strSortOrder = strExpression.getSortOrder();
        PVarchar strDataType = PVarchar.INSTANCE;
        if (!strExpression.evaluate(tuple, ptr)) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("LIKE is FALSE: child expression is null");
            }
            return false;
        }
        String value = null;
        if (LOGGER.isTraceEnabled()) {
            value = (String)strDataType.toObject(ptr, strSortOrder);
        }
        strDataType.coerceBytes(ptr, strDataType, strSortOrder, SortOrder.ASC);
        pattern.matches(ptr);
        if (LOGGER.isTraceEnabled()) {
            boolean matched = (Boolean)PBoolean.INSTANCE.toObject(ptr);
            LOGGER.trace("LIKE(value='" + value + "'pattern='" + pattern.pattern() + "' is " + matched);
        }
        return true;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.init();
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
    }

    @Override
    public PDataType getDataType() {
        return PBoolean.INSTANCE;
    }

    @Override
    public final <T> T accept(ExpressionVisitor<T> visitor) {
        List<T> l = this.acceptChildren(visitor, visitor.visitEnter(this));
        T t = visitor.visitLeave(this, l);
        if (t == null) {
            t = visitor.defaultReturn(this, l);
        }
        return t;
    }

    public String getLiteralPrefix() {
        if (this.pattern == null) {
            return "";
        }
        String pattern = this.pattern.pattern();
        int fromIndex = "\\Q".length();
        return pattern.substring(fromIndex, pattern.indexOf("\\E", fromIndex));
    }

    public boolean endsWithOnlyWildcard() {
        String endsWith;
        if (this.pattern == null) {
            return false;
        }
        String pattern = this.pattern.pattern();
        return pattern.endsWith(endsWith = "\\E.*\\Q\\E") && pattern.lastIndexOf(ANY_ONE, pattern.length() - endsWith.length() - 1) == -1 && pattern.lastIndexOf(ZERO_OR_MORE, pattern.length() - endsWith.length() - 1) == -1;
    }

    @Override
    public String toString() {
        return this.children.get(0) + " LIKE " + this.children.get(1);
    }

    public abstract LikeExpression clone(List<Expression> var1);

    static {
        for (LikeParseNode.LikeType likeType : LikeParseNode.LikeType.values()) {
            LikeExpression.LIKE_TYPE_LITERAL[likeType.ordinal()] = LiteralExpression.newConstant(likeType.name());
        }
    }
}

