/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compat.hbase;

import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.metrics.Gauge;
import org.apache.hadoop.hbase.metrics.impl.MetricRegistriesImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompatUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompatUtil.class);

    public static Class[] getMrMetricsClasses() {
        return new Class[]{Gauge.class, MetricRegistriesImpl.class};
    }

    public static Scan setStartRow(Scan scan, byte[] indexRowKey, boolean inclusive) {
        return scan.withStartRow(indexRowKey, inclusive);
    }

    public static Scan setSingleRow(Scan scan, byte[] indexRowKey) {
        return scan.withStartRow(indexRowKey, true).withStopRow(indexRowKey, true);
    }

    public static synchronized boolean isAnyStoreRefCountLeaked(HMaster master) {
        for (int retries = 5; retries > 0; --retries) {
            boolean isStoreRefCountLeaked = CompatUtil.isStoreRefCountLeaked(master);
            if (!isStoreRefCountLeaked) {
                return false;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted while sleeping", (Throwable)e);
                break;
            }
        }
        return true;
    }

    private static boolean isStoreRefCountLeaked(HMaster master) {
        for (ServerLoad serverLoad : master.getServerManager().getOnlineServers().values()) {
            for (RegionLoad regionLoad : serverLoad.getRegionsLoad().values()) {
                int regionTotalRefCount = regionLoad.getStoreRefCount();
                if (regionTotalRefCount <= 0) continue;
                LOGGER.error("Region {} has refCount leak. Total refCount of all storeFiles combined for the region: {}", (Object)regionLoad.getNameAsString(), (Object)regionTotalRefCount);
                return true;
            }
        }
        return false;
    }
}

