/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import com.google.inject.Inject;
import java.io.IOException;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.tso.AbstractRequestProcessor;
import org.apache.omid.tso.LowWatermarkWriter;
import org.apache.omid.tso.MonitoringContext;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.PersistenceProcessor;
import org.apache.omid.tso.ReplyProcessor;
import org.apache.omid.tso.TSOServerConfig;
import org.apache.omid.tso.TimestampOracle;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.jboss.netty.channel.Channel;

public class RequestProcessorPersistCT
extends AbstractRequestProcessor {
    private final PersistenceProcessor persistenceProcessor;

    @Inject
    RequestProcessorPersistCT(MetricsRegistry metrics, TimestampOracle timestampOracle, PersistenceProcessor persistenceProcessor, Panicker panicker, TSOServerConfig config, LowWatermarkWriter lowWatermarkWriter, ReplyProcessor replyProcessor) throws IOException {
        super(metrics, timestampOracle, panicker, config, lowWatermarkWriter, replyProcessor);
        this.persistenceProcessor = persistenceProcessor;
        this.requestRing = this.disruptor.start();
    }

    @Override
    public void forwardCommit(long startTimestamp, long commitTimestamp, Channel c, MonitoringContext monCtx, Optional<Long> lowWatermark) throws Exception {
        this.persistenceProcessor.addCommitToBatch(startTimestamp, commitTimestamp, c, monCtx, lowWatermark);
    }

    @Override
    public void forwardCommitRetry(long startTimestamp, Channel c, MonitoringContext monCtx) throws Exception {
        this.persistenceProcessor.addCommitRetryToBatch(startTimestamp, c, monCtx);
    }

    @Override
    public void forwardAbort(long startTimestamp, Channel c, MonitoringContext monCtx) throws Exception {
        this.persistenceProcessor.addAbortToBatch(startTimestamp, c, monCtx);
    }

    @Override
    public void forwardTimestamp(long startTimestamp, Channel c, MonitoringContext monCtx) throws Exception {
        this.persistenceProcessor.addTimestampToBatch(startTimestamp, c, monCtx);
    }

    @Override
    public void onTimeout() throws Exception {
        this.persistenceProcessor.triggerCurrentBatchFlush();
    }
}

