/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.transaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.omid.transaction.AbstractTransactionManager;
import org.apache.omid.transaction.Transaction;
import org.apache.omid.transaction.TransactionException;
import org.apache.omid.tso.client.CellId;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;

public abstract class AbstractTransaction<T extends CellId>
implements Transaction {
    private transient Map<String, Object> metadata = new HashMap<String, Object>();
    private final AbstractTransactionManager transactionManager;
    private final long startTimestamp;
    protected long readTimestamp;
    protected long writeTimestamp;
    private final long epoch;
    private long commitTimestamp;
    private boolean isRollbackOnly;
    private final Set<T> writeSet;
    private final Set<T> conflictFreeWriteSet;
    private Transaction.Status status = Transaction.Status.RUNNING;
    private VisibilityLevel visibilityLevel;
    private final boolean isLowLatency;

    public AbstractTransaction(long transactionId, long epoch, Set<T> writeSet, Set<T> conflictFreeWriteSet, AbstractTransactionManager transactionManager, boolean isLowLatency) {
        this(transactionId, transactionId, VisibilityLevel.SNAPSHOT, epoch, writeSet, conflictFreeWriteSet, transactionManager, isLowLatency);
    }

    public AbstractTransaction(long transactionId, long readTimestamp, VisibilityLevel visibilityLevel, long epoch, Set<T> writeSet, Set<T> conflictFreeWriteSet, AbstractTransactionManager transactionManager, boolean isLowLatency) {
        this.startTimestamp = this.writeTimestamp = transactionId;
        this.readTimestamp = readTimestamp;
        this.epoch = epoch;
        this.writeSet = writeSet;
        this.conflictFreeWriteSet = conflictFreeWriteSet;
        this.transactionManager = transactionManager;
        this.visibilityLevel = visibilityLevel;
        this.isLowLatency = isLowLatency;
    }

    public AbstractTransaction(long transactionId, long epoch, Set<T> writeSet, Set<T> conflictFreeWriteSet, AbstractTransactionManager transactionManager, long readTimestamp, long writeTimestamp, boolean isLowLatency) {
        this.startTimestamp = transactionId;
        this.readTimestamp = readTimestamp;
        this.writeTimestamp = writeTimestamp;
        this.epoch = epoch;
        this.writeSet = writeSet;
        this.conflictFreeWriteSet = conflictFreeWriteSet;
        this.transactionManager = transactionManager;
        this.visibilityLevel = VisibilityLevel.SNAPSHOT;
        this.isLowLatency = isLowLatency;
    }

    public void checkpoint() throws TransactionException {
        this.setVisibilityLevel(VisibilityLevel.SNAPSHOT_EXCLUDE_CURRENT);
        this.readTimestamp = this.writeTimestamp++;
        if (this.writeTimestamp % 50L == 0L) {
            throw new TransactionException("Error: number of checkpoing cannot exceed 49");
        }
    }

    public abstract void cleanup();

    @Override
    public long getTransactionId() {
        return this.startTimestamp;
    }

    @Override
    public long getEpoch() {
        return this.epoch;
    }

    @Override
    public Transaction.Status getStatus() {
        return this.status;
    }

    @Override
    public void setRollbackOnly() {
        this.isRollbackOnly = true;
    }

    @Override
    public boolean isRollbackOnly() {
        return this.isRollbackOnly;
    }

    public AbstractTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    @Override
    public long getReadTimestamp() {
        return this.readTimestamp;
    }

    @Override
    public long getWriteTimestamp() {
        return this.writeTimestamp;
    }

    public long getCommitTimestamp() {
        return this.commitTimestamp;
    }

    public VisibilityLevel getVisibilityLevel() {
        return this.visibilityLevel;
    }

    public void setCommitTimestamp(long commitTimestamp) {
        this.commitTimestamp = commitTimestamp;
    }

    public void setVisibilityLevel(VisibilityLevel visibilityLevel) {
        this.visibilityLevel = visibilityLevel;
        if (this.visibilityLevel == VisibilityLevel.SNAPSHOT || this.visibilityLevel == VisibilityLevel.SNAPSHOT_ALL) {
            this.readTimestamp = this.writeTimestamp;
        }
    }

    public void setStatus(Transaction.Status status2) {
        this.status = status2;
    }

    public Set<T> getWriteSet() {
        return this.writeSet;
    }

    public Set<T> getConflictFreeWriteSet() {
        return this.conflictFreeWriteSet;
    }

    public void addWriteSetElement(T element) {
        this.writeSet.add(element);
    }

    public void addConflictFreeWriteSetElement(T element) {
        this.conflictFreeWriteSet.add(element);
    }

    public String toString() {
        return String.format("Tx-%s [%s] (ST=%d, RT=%d, WT=%d, CT=%d, Epoch=%d) WriteSet %s ConflictFreeWriteSet %s", new Object[]{Long.toHexString(this.getTransactionId()), this.status, this.startTimestamp, this.readTimestamp, this.writeTimestamp, this.commitTimestamp, this.epoch, this.writeSet, this.conflictFreeWriteSet});
    }

    @Override
    public Optional<Object> getMetadata(String key) {
        return Optional.fromNullable((Object)this.metadata.get(key));
    }

    @Override
    public void appendMetadata(String key, Object value) {
        List existingValue = (List)this.metadata.get(key);
        if (existingValue == null) {
            ArrayList<Object> newList = new ArrayList<Object>();
            newList.add(value);
            this.metadata.put(key, newList);
        } else {
            existingValue.add(value);
        }
    }

    @Override
    public void setMetadata(String key, Object value) {
        this.metadata.put(key, value);
    }

    @Override
    public boolean isLowLatency() {
        return this.isLowLatency;
    }

    public static final class VisibilityLevel
    extends Enum<VisibilityLevel> {
        public static final /* enum */ VisibilityLevel SNAPSHOT = new VisibilityLevel();
        public static final /* enum */ VisibilityLevel SNAPSHOT_ALL = new VisibilityLevel();
        public static final /* enum */ VisibilityLevel SNAPSHOT_EXCLUDE_CURRENT = new VisibilityLevel();
        private static final /* synthetic */ VisibilityLevel[] $VALUES;

        public static VisibilityLevel[] values() {
            return (VisibilityLevel[])$VALUES.clone();
        }

        public static VisibilityLevel valueOf(String name) {
            return Enum.valueOf(VisibilityLevel.class, name);
        }

        public static VisibilityLevel fromInteger(int number) {
            VisibilityLevel visibilityLevel = SNAPSHOT;
            switch (number) {
                case 0: {
                    visibilityLevel = SNAPSHOT;
                    break;
                }
                case 1: {
                    visibilityLevel = SNAPSHOT_ALL;
                    break;
                }
                case 2: {
                    visibilityLevel = SNAPSHOT_EXCLUDE_CURRENT;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return visibilityLevel;
        }

        static {
            $VALUES = new VisibilityLevel[]{SNAPSHOT, SNAPSHOT_ALL, SNAPSHOT_EXCLUDE_CURRENT};
        }
    }
}

