/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.CoprocessorHConnection;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseShims {
    public static void setKeyValueSequenceId(KeyValue kv, int sequenceId) {
        kv.setSequenceId((long)sequenceId);
    }

    public static Region getRegionCoprocessorRegion(RegionCoprocessorEnvironment env) {
        return env.getRegion();
    }

    public static void flushAllOnlineRegions(HRegionServer regionServer, TableName tableName) throws IOException {
        for (Region r : regionServer.getOnlineRegions(tableName)) {
            r.flush(true);
        }
    }

    public static void addFamilyToHTableDescriptor(HTableDescriptor tableDesc, HColumnDescriptor columnDesc) {
        tableDesc.addFamily(columnDesc);
    }

    public static CellComparator cellComparatorInstance() {
        return new CellComparator();
    }

    public static boolean OmidCompactionEnabled(ObserverContext<RegionCoprocessorEnvironment> env, Store store, String cfFlagValue) {
        HTableDescriptor desc = ((RegionCoprocessorEnvironment)env.getEnvironment()).getRegion().getTableDesc();
        HColumnDescriptor famDesc = desc.getFamily(Bytes.toBytes((String)store.getColumnFamilyName()));
        return Boolean.valueOf(famDesc.getValue(cfFlagValue));
    }

    public static void setCompaction(Connection conn, TableName table, byte[] columnFamily, String key, String value) throws IOException {
        try (Admin admin = conn.getAdmin();){
            HTableDescriptor desc = admin.getTableDescriptor(table);
            HColumnDescriptor cfDesc = desc.getFamily(columnFamily);
            cfDesc.setValue(key, value);
            admin.modifyColumn(table, cfDesc);
        }
    }

    public static int getNoRetriesNumber() {
        return 0;
    }

    public static Connection newServerConnection(Configuration config, RegionCoprocessorEnvironment env) throws IOException {
        return new CoprocessorHConnection(config, (HRegionServer)env.getRegionServerServices());
    }
}

