/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.jdkadapter;

import com.ibm.icu.impl.icuadapter.TimeZoneJDK;
import com.ibm.icu.impl.jdkadapter.TimeZoneICU;
import com.ibm.icu.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class CalendarICU
extends Calendar {
    private static final long serialVersionUID = -8641226371713600671L;
    private com.ibm.icu.util.Calendar fIcuCal;

    private CalendarICU(com.ibm.icu.util.Calendar icuCal) {
        this.fIcuCal = icuCal;
        this.init();
    }

    public static Calendar wrap(com.ibm.icu.util.Calendar icuCal) {
        return new CalendarICU(icuCal);
    }

    public com.ibm.icu.util.Calendar unwrap() {
        this.sync();
        return this.fIcuCal;
    }

    @Override
    public void add(int field, int amount) {
        this.sync();
        this.fIcuCal.add(field, amount);
    }

    @Override
    public Object clone() {
        this.sync();
        CalendarICU other = (CalendarICU)super.clone();
        other.fIcuCal = (com.ibm.icu.util.Calendar)this.fIcuCal.clone();
        return other;
    }

    @Override
    public int compareTo(com.ibm.icu.util.Calendar anotherCalendar) {
        this.sync();
        long thisMillis = this.getTimeInMillis();
        long otherMillis = anotherCalendar.getTimeInMillis();
        return thisMillis > otherMillis ? 1 : (thisMillis == otherMillis ? 0 : -1);
    }

    @Override
    protected void complete() {
    }

    @Override
    protected void computeFields() {
    }

    @Override
    protected void computeTime() {
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CalendarICU) {
            this.sync();
            return ((CalendarICU)obj).fIcuCal.equals(this.fIcuCal);
        }
        return false;
    }

    @Override
    public int get(int field) {
        this.sync();
        return this.fIcuCal.get(field);
    }

    @Override
    public int getActualMaximum(int field) {
        return this.fIcuCal.getActualMaximum(field);
    }

    @Override
    public int getActualMinimum(int field) {
        return this.fIcuCal.getActualMinimum(field);
    }

    @Override
    public String getDisplayName(int field, int style, Locale locale) {
        int fieldVal;
        if (field < 0 || field >= 17 || style != 1 && style != 2 && style != 0) {
            throw new IllegalArgumentException("Bad field or style.");
        }
        DateFormatSymbols dfs = DateFormatSymbols.getInstance(locale);
        String[] array = CalendarICU.getFieldStrings(field, style, dfs);
        if (array != null && (fieldVal = this.get(field)) < array.length) {
            return array[fieldVal];
        }
        return null;
    }

    @Override
    public Map<String, Integer> getDisplayNames(int field, int style, Locale locale) {
        Map<String, Integer> longMap;
        if (field < 0 || field >= 17 || style != 1 && style != 2 && style != 0) {
            throw new IllegalArgumentException("Bad field or style.");
        }
        DateFormatSymbols dfs = DateFormatSymbols.getInstance(locale);
        if (style != 0) {
            return CalendarICU.getFieldStringsMap(field, style, dfs);
        }
        Map<String, Integer> result = CalendarICU.getFieldStringsMap(field, 1, dfs);
        if (result == null) {
            return null;
        }
        if ((field == 2 || field == 7) && (longMap = CalendarICU.getFieldStringsMap(field, 2, dfs)) != null) {
            result.putAll(longMap);
        }
        return result;
    }

    @Override
    public int getGreatestMinimum(int field) {
        return this.fIcuCal.getGreatestMinimum(field);
    }

    @Override
    public int getLeastMaximum(int field) {
        return this.fIcuCal.getLeastMaximum(field);
    }

    @Override
    public int getMaximum(int field) {
        return this.fIcuCal.getMaximum(field);
    }

    @Override
    public int getMinimalDaysInFirstWeek() {
        return this.fIcuCal.getMinimalDaysInFirstWeek();
    }

    @Override
    public int getMinimum(int field) {
        return this.fIcuCal.getMinimum(field);
    }

    @Override
    public long getTimeInMillis() {
        this.sync();
        return this.fIcuCal.getTimeInMillis();
    }

    @Override
    public TimeZone getTimeZone() {
        return TimeZoneICU.wrap(this.fIcuCal.getTimeZone());
    }

    @Override
    public int hashCode() {
        this.sync();
        return this.fIcuCal.hashCode();
    }

    @Override
    public boolean isLenient() {
        return this.fIcuCal.isLenient();
    }

    @Override
    public void roll(int field, boolean up) {
        this.sync();
        this.fIcuCal.roll(field, up);
    }

    @Override
    public void roll(int field, int amount) {
        this.sync();
        this.fIcuCal.roll(field, amount);
    }

    @Override
    public void set(int field, int value) {
        this.sync();
        this.fIcuCal.set(field, value);
    }

    @Override
    public void setFirstDayOfWeek(int value) {
        this.fIcuCal.setFirstDayOfWeek(value);
    }

    @Override
    public void setLenient(boolean lenient) {
        this.fIcuCal.setLenient(lenient);
    }

    @Override
    public void setMinimalDaysInFirstWeek(int value) {
        this.fIcuCal.setMinimalDaysInFirstWeek(value);
    }

    @Override
    public void setTimeInMillis(long millis) {
        this.fIcuCal.setTimeInMillis(millis);
    }

    @Override
    public void setTimeZone(TimeZone value) {
        this.fIcuCal.setTimeZone(TimeZoneJDK.wrap(value));
    }

    @Override
    public String toString() {
        this.sync();
        return "CalendarICU: " + this.fIcuCal.toString();
    }

    private void sync() {
        for (int i = 0; i < this.isSet.length; ++i) {
            if (this.isSet[i]) continue;
            this.isSet[i] = true;
            try {
                this.fIcuCal.clear(i);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    private void init() {
        for (int i = 0; i < this.isSet.length; ++i) {
            this.isSet[i] = true;
        }
    }

    private static String[] getFieldStrings(int field, int style, DateFormatSymbols dfs) {
        String[] result = null;
        switch (field) {
            case 9: {
                result = dfs.getAmPmStrings();
                break;
            }
            case 7: {
                result = style == 2 ? dfs.getWeekdays() : dfs.getShortWeekdays();
                break;
            }
            case 0: {
                result = dfs.getEras();
                break;
            }
            case 2: {
                result = style == 2 ? dfs.getMonths() : dfs.getShortMonths();
            }
        }
        return result;
    }

    private static Map<String, Integer> getFieldStringsMap(int field, int style, DateFormatSymbols dfs) {
        String[] strings = CalendarICU.getFieldStrings(field, style, dfs);
        if (strings == null) {
            return null;
        }
        HashMap<String, Integer> res = new HashMap<String, Integer>();
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i].length() == 0) continue;
            res.put(strings[i], i);
        }
        return res;
    }
}

