/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.CharsetDecoderICU;
import com.ibm.icu.charset.CharsetEncoderICU;
import com.ibm.icu.charset.CharsetICU;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

class CharsetBOCU1
extends CharsetICU {
    private static final byte BOCU1_ASCII_PREV = 64;
    private static final int BOCU1_MIN = 33;
    private static final int BOCU1_MIDDLE = 144;
    private static final int BOCU1_MAX_TRAIL = 255;
    private static final int BOCU1_RESET = 255;
    private static final int BOCU1_TRAIL_CONTROLS_COUNT = 20;
    private static final int BOCU1_TRAIL_BYTE_OFFSET = 13;
    private static final int BOCU1_TRAIL_COUNT = 243;
    private static final int BOCU1_SINGLE = 64;
    private static final int BOCU1_LEAD_2 = 43;
    private static final int BOCU1_LEAD_3 = 3;
    private static final int BOCU1_REACH_POS_1 = 63;
    private static final int BOCU1_REACH_NEG_1 = -64;
    private static final int BOCU1_REACH_POS_2 = 10512;
    private static final int BOCU1_REACH_NEG_2 = -10513;
    private static final int BOCU1_REACH_POS_3 = 187659;
    private static final int BOCU1_REACH_NEG_3 = -187660;
    private static final int BOCU1_START_POS_2 = 208;
    private static final int BOCU1_START_POS_3 = 251;
    private static final int BOCU1_START_POS_4 = 254;
    private static final int BOCU1_START_NEG_2 = 80;
    private static final int BOCU1_START_NEG_3 = 37;
    private static final int[] bocu1ByteToTrail = new int[]{-1, 0, 1, 2, 3, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, -1, -1, 16, 17, 18, 19, -1};
    private static final int[] bocu1TrailToByte = new int[]{1, 2, 3, 4, 5, 6, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31};
    protected byte[] fromUSubstitution = new byte[]{26};

    private static int BOCU1_LENGTH_FROM_PACKED(int packed) {
        return ((long)packed & 0xFFFFFFFFL) < 0x4000000L ? packed >> 24 : 4;
    }

    private static int BOCU1_TRAIL_TO_BYTE(int trail) {
        return trail >= 20 ? trail + 13 : bocu1TrailToByte[trail];
    }

    private static int BOCU1_SIMPLE_PREV(int c) {
        return (c & 0xFFFFFF80) + 64;
    }

    private static int bocu1Prev(int c) {
        if (c <= 12447) {
            return 12400;
        }
        if (19968 <= c && c <= 40869) {
            return 30481;
        }
        if (44032 <= c) {
            return 49617;
        }
        return CharsetBOCU1.BOCU1_SIMPLE_PREV(c);
    }

    private static int BOCU1_PREV(int c) {
        return c < 12352 || c > 55203 ? CharsetBOCU1.BOCU1_SIMPLE_PREV(c) : CharsetBOCU1.bocu1Prev(c);
    }

    private static boolean DIFF_IS_SINGLE(int diff) {
        return -64 <= diff && diff <= 63;
    }

    private static int PACK_SINGLE_DIFF(int diff) {
        return 144 + diff;
    }

    private static boolean DIFF_IS_DOUBLE(int diff) {
        return -10513 <= diff && diff <= 10512;
    }

    public CharsetBOCU1(String icuCanonicalName, String javaCanonicalName, String[] aliases) {
        super(icuCanonicalName, javaCanonicalName, aliases);
        this.maxBytesPerChar = 4;
        this.minBytesPerChar = 1;
        this.maxCharsPerByte = 1.0f;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new CharsetDecoderBOCU(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new CharsetEncoderBOCU(this);
    }

    @Override
    void getUnicodeSetImpl(UnicodeSet setFillIn, int which) {
        CharsetICU.getCompleteUnicodeSet(setFillIn);
    }

    static class CharsetDecoderBOCU
    extends CharsetDecoderICU {
        int byteIndex;
        int sourceIndex;
        int nextSourceIndex;
        int prev;
        int c;
        int diff;
        int count;
        byte[] bytes;
        CoderResult cr;
        private static final int fastSingle = 0;
        private static final int getTrail = 1;
        private static final int regularLoop = 2;
        private static final int endLoop = 3;
        private boolean LabelLoop;
        private boolean afterTrail;
        private int labelType;

        public CharsetDecoderBOCU(CharsetICU cs) {
            super(cs);
        }

        private int decodeBocu1LeadByte(int b) {
            int countValue;
            int diffValue;
            if (b >= 80) {
                if (b < 251) {
                    diffValue = (b - 208) * 243 + 63 + 1;
                    countValue = 1;
                } else if (b < 254) {
                    diffValue = (b - 251) * 243 * 243 + 10512 + 1;
                    countValue = 2;
                } else {
                    diffValue = 187660;
                    countValue = 3;
                }
            } else if (b >= 37) {
                diffValue = (b - 80) * 243 + -64;
                countValue = 1;
            } else if (b > 33) {
                diffValue = (b - 37) * 243 * 243 + -10513;
                countValue = 2;
            } else {
                diffValue = -14536567;
                countValue = 3;
            }
            return diffValue << 2 | countValue;
        }

        private int decodeBocu1TrailByte(int countValue, int b) {
            b = (b &= 0xFF) <= 32 ? bocu1ByteToTrail[b] : (b -= 13);
            if (countValue == 1) {
                return b;
            }
            if (countValue == 2) {
                return b * 243;
            }
            return b * 59049;
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            this.cr = CoderResult.UNDERFLOW;
            this.LabelLoop = true;
            this.afterTrail = false;
            this.labelType = 0;
            this.prev = this.toUnicodeStatus;
            if (this.prev == 0) {
                this.prev = 64;
            }
            this.diff = this.mode;
            this.count = this.diff & 3;
            this.diff >>= 2;
            this.byteIndex = this.toULength;
            this.bytes = this.toUBytesArray;
            this.sourceIndex = this.byteIndex == 0 ? 0 : -1;
            this.nextSourceIndex = 0;
            if (this.count > 0 && this.byteIndex > 0 && target.position() < target.limit()) {
                this.labelType = 1;
            }
            while (this.LabelLoop) {
                switch (this.labelType) {
                    case 0: {
                        this.labelType = this.fastSingle(source, target, offsets);
                        break;
                    }
                    case 1: {
                        this.labelType = this.getTrail(source, target, offsets);
                        break;
                    }
                    case 2: {
                        this.labelType = this.afterGetTrail(source, target, offsets);
                        break;
                    }
                    case 3: {
                        this.endLoop(source, target, offsets);
                    }
                }
            }
            return this.cr;
        }

        private int fastSingle(ByteBuffer source, CharBuffer target, IntBuffer offsets) {
            this.labelType = 2;
            this.diff = source.limit() - source.position();
            this.count = target.limit() - target.position();
            if (this.count > this.diff) {
                this.count = this.diff;
            }
            while (this.count > 0) {
                this.c = source.get(source.position()) & 0xFF;
                if (80 <= this.c && this.c < 208) {
                    this.c = this.prev + (this.c - 144);
                    if (this.c >= 12288) break;
                    target.put((char)this.c);
                    if (offsets != null) {
                        offsets.put(this.nextSourceIndex++);
                    }
                    this.prev = CharsetBOCU1.BOCU1_SIMPLE_PREV(this.c);
                } else {
                    if ((this.c & 0xFF) > 32) break;
                    if ((this.c & 0xFF) != 32) {
                        this.prev = 64;
                    }
                    target.put((char)this.c);
                    if (offsets != null) {
                        offsets.put(this.nextSourceIndex++);
                    }
                }
                source.position(source.position() + 1);
                --this.count;
            }
            this.sourceIndex = this.nextSourceIndex;
            return this.labelType;
        }

        private int getTrail(ByteBuffer source, CharBuffer target, IntBuffer offsets) {
            this.labelType = 2;
            do {
                if (source.position() >= source.limit()) {
                    this.labelType = 3;
                    return this.labelType;
                }
                ++this.nextSourceIndex;
                byte by = source.get();
                this.bytes[this.byteIndex++] = by;
                this.c = by;
                this.c = this.decodeBocu1TrailByte(this.count, this.c);
                if (this.c < 0) {
                    this.cr = CoderResult.malformedForLength(1);
                    this.labelType = 3;
                    return this.labelType;
                }
                this.diff += this.c;
            } while (--this.count != 0);
            this.byteIndex = 0;
            this.c = this.prev + this.diff;
            if (this.c > 0x10FFFF) {
                this.cr = CoderResult.malformedForLength(1);
                this.labelType = 3;
                return this.labelType;
            }
            this.afterTrail = true;
            return this.labelType;
        }

        private int afterGetTrail(ByteBuffer source, CharBuffer target, IntBuffer offsets) {
            while (this.afterTrail || source.hasRemaining()) {
                if (!this.afterTrail) {
                    if (target.position() >= target.limit()) {
                        this.cr = CoderResult.OVERFLOW;
                        break;
                    }
                    ++this.nextSourceIndex;
                    this.c = source.get() & 0xFF;
                    if (80 <= this.c && this.c < 208) {
                        this.c = this.prev + (this.c - 144);
                        if (this.c < 12288) {
                            target.put((char)this.c);
                            if (offsets != null) {
                                offsets.put(this.sourceIndex);
                            }
                            this.prev = CharsetBOCU1.BOCU1_SIMPLE_PREV(this.c);
                            this.sourceIndex = this.nextSourceIndex;
                            this.labelType = 0;
                            return this.labelType;
                        }
                    } else {
                        if (this.c <= 32) {
                            if (this.c != 32) {
                                this.prev = 64;
                            }
                            target.put((char)this.c);
                            if (offsets != null) {
                                offsets.put(this.sourceIndex);
                            }
                            this.sourceIndex = this.nextSourceIndex;
                            continue;
                        }
                        if (37 <= this.c && this.c < 251 && source.hasRemaining()) {
                            this.diff = this.c >= 144 ? (this.c - 208) * 243 + 63 + 1 : (this.c - 80) * 243 + -64;
                            ++this.nextSourceIndex;
                            this.c = this.decodeBocu1TrailByte(1, source.get());
                            if (this.c < 0 || ((long)(this.c = this.prev + this.diff + this.c) & 0xFFFFFFFFL) > 0x10FFFFL) {
                                this.bytes[0] = source.get(source.position() - 2);
                                this.bytes[1] = source.get(source.position() - 1);
                                this.byteIndex = 2;
                                this.cr = CoderResult.malformedForLength(2);
                                break;
                            }
                        } else {
                            if (this.c == 255) {
                                this.prev = 64;
                                this.sourceIndex = this.nextSourceIndex;
                                continue;
                            }
                            this.bytes[0] = (byte)this.c;
                            this.byteIndex = 1;
                            this.diff = this.decodeBocu1LeadByte(this.c);
                            this.count = this.diff & 3;
                            this.diff >>= 2;
                            this.getTrail(source, target, offsets);
                            if (this.labelType != 2) {
                                return this.labelType;
                            }
                        }
                    }
                }
                if (this.afterTrail) {
                    this.afterTrail = false;
                }
                this.prev = CharsetBOCU1.BOCU1_PREV(this.c);
                if (this.c <= 65535) {
                    target.put((char)this.c);
                    if (offsets != null) {
                        offsets.put(this.sourceIndex);
                    }
                } else {
                    target.put(UTF16.getLeadSurrogate(this.c));
                    if (target.hasRemaining()) {
                        target.put(UTF16.getTrailSurrogate(this.c));
                        if (offsets != null) {
                            offsets.put(this.sourceIndex);
                            offsets.put(this.sourceIndex);
                        }
                    } else {
                        if (offsets != null) {
                            offsets.put(this.sourceIndex);
                        }
                        this.charErrorBufferArray[0] = UTF16.getTrailSurrogate(this.c);
                        this.charErrorBufferLength = 1;
                        this.cr = CoderResult.OVERFLOW;
                        break;
                    }
                }
                this.sourceIndex = this.nextSourceIndex;
            }
            this.labelType = 3;
            return this.labelType;
        }

        private void endLoop(ByteBuffer source, CharBuffer target, IntBuffer offsets) {
            if (this.cr.isMalformed()) {
                this.toUnicodeStatus = 64;
                this.mode = 0;
            } else {
                this.toUnicodeStatus = this.prev;
                this.mode = this.diff << 2 | this.count;
            }
            this.toULength = this.byteIndex;
            this.LabelLoop = false;
        }
    }

    class CharsetEncoderBOCU
    extends CharsetEncoderICU {
        int sourceIndex;
        int nextSourceIndex;
        int prev;
        int c;
        int diff;
        boolean checkNegative;
        boolean LoopAfterTrail;
        int targetCapacity;
        CoderResult cr;
        private static final int fastSingle = 0;
        private static final int getTrail = 1;
        private static final int regularLoop = 2;
        private boolean LabelLoop;
        private int labelType;

        public CharsetEncoderBOCU(CharsetICU cs) {
            super(cs, CharsetBOCU1.this.fromUSubstitution);
            this.labelType = 0;
        }

        private int NEGDIVMOD(int n, int d, int m) {
            this.diff = n;
            m = this.diff % d;
            this.diff /= d;
            if (m < 0) {
                --this.diff;
                m += d;
            }
            return m;
        }

        private int packDiff(int n) {
            int result;
            int m = 0;
            this.diff = n;
            if (this.diff >= -64) {
                if (this.diff <= 10512) {
                    this.diff -= 64;
                    result = 0x2000000;
                    m = this.diff % 243;
                    this.diff /= 243;
                    result |= CharsetBOCU1.BOCU1_TRAIL_TO_BYTE(m);
                    result |= 208 + this.diff << 8;
                } else if (this.diff <= 187659) {
                    this.diff -= 10513;
                    result = 0x3000000;
                    m = this.diff % 243;
                    this.diff /= 243;
                    result |= CharsetBOCU1.BOCU1_TRAIL_TO_BYTE(m);
                    m = this.diff % 243;
                    this.diff /= 243;
                    result |= CharsetBOCU1.BOCU1_TRAIL_TO_BYTE(m) << 8;
                    result |= 251 + this.diff << 16;
                } else {
                    this.diff -= 187660;
                    m = this.diff % 243;
                    this.diff /= 243;
                    result = CharsetBOCU1.BOCU1_TRAIL_TO_BYTE(m);
                    m = this.diff % 243;
                    this.diff /= 243;
                    result |= CharsetBOCU1.BOCU1_TRAIL_TO_BYTE(m) << 8;
                    result |= CharsetBOCU1.BOCU1_TRAIL_TO_BYTE(this.diff) << 16;
                    result = (int)((long)result | 0xFE000000L);
                }
            } else if (this.diff >= -10513) {
                this.diff -= -64;
                result = 0x2000000;
                m = this.NEGDIVMOD(this.diff, 243, m);
                result |= CharsetBOCU1.BOCU1_TRAIL_TO_BYTE(m);
                result |= 80 + this.diff << 8;
            } else if (this.diff >= -187660) {
                this.diff -= -10513;
                result = 0x3000000;
                m = this.NEGDIVMOD(this.diff, 243, m);
                result |= CharsetBOCU1.BOCU1_TRAIL_TO_BYTE(m);
                m = this.NEGDIVMOD(this.diff, 243, m);
                result |= CharsetBOCU1.BOCU1_TRAIL_TO_BYTE(m) << 8;
                result |= 37 + this.diff << 16;
            } else {
                this.diff -= -187660;
                m = this.NEGDIVMOD(this.diff, 243, m);
                result = CharsetBOCU1.BOCU1_TRAIL_TO_BYTE(m);
                m = this.NEGDIVMOD(this.diff, 243, m);
                result |= CharsetBOCU1.BOCU1_TRAIL_TO_BYTE(m) << 8;
                m = this.diff + 243;
                result |= CharsetBOCU1.BOCU1_TRAIL_TO_BYTE(m) << 16;
                result |= 0x21000000;
            }
            return result;
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            this.cr = CoderResult.UNDERFLOW;
            this.LabelLoop = true;
            this.checkNegative = false;
            this.LoopAfterTrail = false;
            this.targetCapacity = target.limit() - target.position();
            this.c = this.fromUChar32;
            this.prev = this.fromUnicodeStatus;
            if (this.prev == 0) {
                this.prev = 64;
            }
            this.sourceIndex = this.c == 0 ? 0 : -1;
            this.nextSourceIndex = 0;
            if (this.c != 0 && this.targetCapacity > 0) {
                this.labelType = 1;
            }
            while (this.LabelLoop) {
                switch (this.labelType) {
                    case 0: {
                        this.labelType = this.fastSingle(source, target, offsets);
                        break;
                    }
                    case 1: {
                        this.labelType = this.getTrail(source, target, offsets);
                        break;
                    }
                    case 2: {
                        this.labelType = this.regularLoop(source, target, offsets);
                    }
                }
            }
            return this.cr;
        }

        private int fastSingle(CharBuffer source, ByteBuffer target, IntBuffer offsets) {
            this.diff = source.limit() - source.position();
            if (this.targetCapacity > this.diff) {
                this.targetCapacity = this.diff;
            }
            while (this.targetCapacity > 0) {
                char c = source.get(source.position());
                this.c = c;
                if (c >= '\u3000') break;
                if (this.c <= 32) {
                    if (this.c != 32) {
                        this.prev = 64;
                    }
                    target.put((byte)this.c);
                    if (offsets != null) {
                        offsets.put(this.nextSourceIndex++);
                    }
                    source.position(source.position() + 1);
                    --this.targetCapacity;
                    continue;
                }
                this.diff = this.c - this.prev;
                if (!CharsetBOCU1.DIFF_IS_SINGLE(this.diff)) break;
                this.prev = CharsetBOCU1.BOCU1_SIMPLE_PREV(this.c);
                target.put((byte)CharsetBOCU1.PACK_SINGLE_DIFF(this.diff));
                if (offsets != null) {
                    offsets.put(this.nextSourceIndex++);
                }
                source.position(source.position() + 1);
                --this.targetCapacity;
            }
            return 2;
        }

        private int getTrail(CharBuffer source, ByteBuffer target, IntBuffer offsets) {
            if (source.hasRemaining()) {
                char trail = source.get(source.position());
                if (UTF16.isTrailSurrogate(trail)) {
                    source.position(source.position() + 1);
                    ++this.nextSourceIndex;
                    this.c = UCharacter.getCodePoint((char)this.c, trail);
                }
            } else {
                this.c = -this.c;
                this.checkNegative = true;
            }
            this.LoopAfterTrail = true;
            return 2;
        }

        private int regularLoop(CharBuffer source, ByteBuffer target, IntBuffer offsets) {
            if (!this.LoopAfterTrail) {
                this.targetCapacity = target.limit() - target.position();
                this.sourceIndex = this.nextSourceIndex;
            }
            while (this.LoopAfterTrail || source.hasRemaining()) {
                if (this.LoopAfterTrail || this.targetCapacity > 0) {
                    if (!this.LoopAfterTrail) {
                        this.c = source.get();
                        ++this.nextSourceIndex;
                        if (this.c <= 32) {
                            if (this.c != 32) {
                                this.prev = 64;
                            }
                            target.put((byte)this.c);
                            if (offsets != null) {
                                offsets.put(this.sourceIndex++);
                            }
                            --this.targetCapacity;
                            this.sourceIndex = this.nextSourceIndex;
                            continue;
                        }
                        if (UTF16.isLeadSurrogate((char)this.c)) {
                            this.getTrail(source, target, offsets);
                            if (this.checkNegative) break;
                        }
                    }
                    if (this.LoopAfterTrail) {
                        this.LoopAfterTrail = false;
                    }
                    this.diff = this.c - this.prev;
                    this.prev = CharsetBOCU1.BOCU1_PREV(this.c);
                    if (CharsetBOCU1.DIFF_IS_SINGLE(this.diff)) {
                        target.put((byte)CharsetBOCU1.PACK_SINGLE_DIFF(this.diff));
                        if (offsets != null) {
                            offsets.put(this.sourceIndex++);
                        }
                        --this.targetCapacity;
                        this.sourceIndex = this.nextSourceIndex;
                        if (this.c >= 12288) continue;
                        this.labelType = 0;
                        return this.labelType;
                    }
                    if (CharsetBOCU1.DIFF_IS_DOUBLE(this.diff) && 2 <= this.targetCapacity) {
                        int m = 0;
                        if (this.diff >= 0) {
                            this.diff -= 64;
                            m = this.diff % 243;
                            this.diff /= 243;
                            this.diff += 208;
                        } else {
                            this.diff -= -64;
                            m = this.NEGDIVMOD(this.diff, 243, m);
                            this.diff += 80;
                        }
                        target.put((byte)this.diff);
                        target.put((byte)CharsetBOCU1.BOCU1_TRAIL_TO_BYTE(m));
                        if (offsets != null) {
                            offsets.put(this.sourceIndex);
                            offsets.put(this.sourceIndex);
                        }
                        this.targetCapacity -= 2;
                        this.sourceIndex = this.nextSourceIndex;
                        continue;
                    }
                    this.diff = this.packDiff(this.diff);
                    int length = CharsetBOCU1.BOCU1_LENGTH_FROM_PACKED(this.diff);
                    if (length <= this.targetCapacity) {
                        switch (length) {
                            case 4: {
                                target.put((byte)(this.diff >> 24));
                                if (offsets != null) {
                                    offsets.put(this.sourceIndex);
                                }
                            }
                            case 3: {
                                target.put((byte)(this.diff >> 16));
                                if (offsets != null) {
                                    offsets.put(this.sourceIndex);
                                }
                            }
                            case 2: {
                                target.put((byte)(this.diff >> 8));
                                if (offsets != null) {
                                    offsets.put(this.sourceIndex);
                                }
                                target.put((byte)this.diff);
                                if (offsets == null) break;
                                offsets.put(this.sourceIndex);
                            }
                        }
                        this.targetCapacity -= length;
                        this.sourceIndex = this.nextSourceIndex;
                        continue;
                    }
                    ByteBuffer error = ByteBuffer.wrap(this.errorBuffer);
                    switch (length -= this.targetCapacity) {
                        case 3: {
                            error.put((byte)(this.diff >> 16));
                        }
                        case 2: {
                            error.put((byte)(this.diff >> 8));
                        }
                        case 1: {
                            error.put((byte)this.diff);
                        }
                    }
                    this.errorBufferLength = length;
                    this.diff >>= 8 * length;
                    switch (this.targetCapacity) {
                        case 3: {
                            target.put((byte)(this.diff >> 16));
                            if (offsets != null) {
                                offsets.put(this.sourceIndex);
                            }
                        }
                        case 2: {
                            target.put((byte)(this.diff >> 8));
                            if (offsets != null) {
                                offsets.put(this.sourceIndex);
                            }
                        }
                        case 1: {
                            target.put((byte)this.diff);
                            if (offsets == null) break;
                            offsets.put(this.sourceIndex);
                        }
                    }
                    this.targetCapacity = 0;
                    this.cr = CoderResult.OVERFLOW;
                    break;
                }
                this.cr = CoderResult.OVERFLOW;
                break;
            }
            this.fromUChar32 = this.c < 0 ? -this.c : 0;
            this.fromUnicodeStatus = this.prev;
            this.LabelLoop = false;
            this.labelType = 0;
            return this.labelType;
        }
    }
}

