/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.DataInput;
import java.io.IOException;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.util.ByteUtil;

public class PrefixByteDecoder {
    private final int maxLength;
    private final ImmutableBytesWritable previous;

    public PrefixByteDecoder() {
        this.maxLength = -1;
        this.previous = new ImmutableBytesWritable(ByteUtil.EMPTY_BYTE_ARRAY);
    }

    public PrefixByteDecoder(int maxLength) {
        if (maxLength > 0) {
            this.maxLength = maxLength;
            this.previous = new ImmutableBytesWritable(new byte[maxLength], 0, 0);
        } else {
            this.maxLength = -1;
            this.previous = new ImmutableBytesWritable(ByteUtil.EMPTY_BYTE_ARRAY);
        }
    }

    public void reset() {
        this.previous.set(this.previous.get(), 0, 0);
    }

    public ImmutableBytesWritable decode(DataInput in) throws IOException {
        byte[] b;
        int prefixLen = WritableUtils.readVInt((DataInput)in);
        int suffixLen = WritableUtils.readVInt((DataInput)in);
        int length = prefixLen + suffixLen;
        if (this.maxLength == -1) {
            b = new byte[length];
            System.arraycopy(this.previous.get(), this.previous.getOffset(), b, 0, prefixLen);
        } else {
            b = this.previous.get();
        }
        in.readFully(b, prefixLen, suffixLen);
        this.previous.set(b, 0, length);
        return this.previous;
    }
}

